/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow;

import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.table.Table;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class DictionaryInitializer {
    private final BufferAllocator allocator;
    private final DictionaryProvider.MapDictionaryProvider dictionaryProvider;

    public DictionaryInitializer(BufferAllocator allocator, DictionaryProvider.MapDictionaryProvider dictionaryProvider) {
        this.allocator = allocator;
        this.dictionaryProvider = dictionaryProvider;
    }

    public List<ValueVector> initializeDictionaries(Table table, Schema schema) {
        ArrayList<ValueVector> dictionaryVectors = new ArrayList<ValueVector>();
        for (int i = 0; i < table.width(); ++i) {
            Field arrowField;
            ColumnType columnType = ((Column)table.select().columns().get(i)).type();
            if (!this.isNominalNonUtf8Column(columnType, arrowField = schema.getFields().get(i))) continue;
            this.processNominalColumn(table, arrowField, i, dictionaryVectors);
        }
        return dictionaryVectors;
    }

    private boolean isNominalNonUtf8Column(ColumnType<?> columnType, Field arrowField) {
        return ColumnType.NOMINAL.equals(columnType) && !(arrowField.getType() instanceof ArrowType.Utf8);
    }

    private void processNominalColumn(Table table, Field arrowField, int columnIndex, List<ValueVector> dictionaryVectors) {
        com.rapidminer.belt.column.Dictionary mapping = ((Column)table.select().columns().get(columnIndex)).getDictionary();
        FieldVector dictionaryVector = this.getDictionaryVector(mapping, arrowField);
        if (dictionaryVector != null) {
            this.addDictionaryToProvider(arrowField, dictionaryVector, dictionaryVectors);
        }
    }

    private FieldVector getDictionaryVector(com.rapidminer.belt.column.Dictionary mapping, Field arrowField) {
        if (mapping == null) {
            return null;
        }
        if (mapping.size() > 0) {
            return this.createDictionary(mapping);
        }
        if (mapping.size() == 0 && !this.containsNonNullValues(mapping)) {
            return this.createPlaceholderDictionaryVector(arrowField);
        }
        return null;
    }

    private void addDictionaryToProvider(Field arrowField, FieldVector dictionaryVector, List<ValueVector> dictionaryVectors) {
        DictionaryEncoding dictEncoding = arrowField.getDictionary();
        if (dictEncoding != null) {
            this.dictionaryProvider.put(new Dictionary(dictionaryVector, dictEncoding));
            dictionaryVectors.add(dictionaryVector);
        }
    }

    private VarCharVector createDictionary(com.rapidminer.belt.column.Dictionary mapping) {
        byte[] utf8;
        int valueCount = mapping.size();
        byte[][] encoded = new byte[valueCount][];
        int totalBytes = 0;
        for (int i = 0; i < valueCount; ++i) {
            String value = mapping.get(i + 1);
            if (value != null) {
                utf8 = value.getBytes(StandardCharsets.UTF_8);
                totalBytes += utf8.length;
                encoded[i] = utf8;
                continue;
            }
            encoded[i] = null;
        }
        VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
        dictionaryVector.allocateNew(totalBytes, valueCount);
        for (int i = 0; i < valueCount; ++i) {
            utf8 = encoded[i];
            if (utf8 != null) {
                dictionaryVector.set(i, utf8);
                continue;
            }
            dictionaryVector.setNull(i);
        }
        dictionaryVector.setValueCount(valueCount);
        return dictionaryVector;
    }

    private VarCharVector createPlaceholderDictionaryVector(Field arrowField) {
        String placeholderValue = "unknown";
        VarCharVector vector = new VarCharVector(arrowField.getName(), this.allocator);
        vector.allocateNewSafe();
        vector.setSafe(0, placeholderValue.getBytes(StandardCharsets.UTF_8));
        vector.setValueCount(1);
        return vector;
    }

    private boolean containsNonNullValues(com.rapidminer.belt.column.Dictionary mapping) {
        for (int i = 0; i < mapping.size(); ++i) {
            if (mapping.get(i) == null) continue;
            return true;
        }
        return false;
    }

    public void closeDictionaryVectors(List<ValueVector> dictionaryVectors) {
        for (ValueVector vector : dictionaryVectors) {
            vector.close();
        }
    }
}

