/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.execution.Context;
import com.rapidminer.belt.table.Appender;
import com.rapidminer.belt.table.Builders;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.belt.util.Belt;
import com.rapidminer.belt.util.ColumnAnnotation;
import com.rapidminer.belt.util.ColumnMetaData;
import com.rapidminer.belt.util.ColumnReference;
import com.rapidminer.belt.util.ColumnRole;
import com.rapidminer.extension.pythonscripting.serialization.Deserializer;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converters;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class TabularDataToArrowDeserializer
implements Deserializer {
    /*
     * Exception decompiling
     */
    @Override
    public IOObject deserialize(Map<String, InputStream> streams, @Nullable Operator operator) throws IOException, UserError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream getArrowInputStream(Map<String, InputStream> streams) {
        InputStream arrowInputStream = streams.get("arrow");
        if (arrowInputStream == null) {
            throw new IllegalArgumentException("No InputStream found for extension 'arrow'.");
        }
        return new BufferedInputStream(arrowInputStream);
    }

    private IOObject processArrowStream(ArrowStreamReader arrowReader, Operator operator) throws IOException, UserError {
        VectorSchemaRoot schemaRoot = arrowReader.getVectorSchemaRoot();
        if (this.isSchemaEmpty(schemaRoot)) {
            return this.createEmptyTable();
        }
        Schema schema = schemaRoot.getSchema();
        if (!arrowReader.loadNextBatch()) {
            return this.createEmptyTableWithHeaders(schema);
        }
        this.processDictionaries(arrowReader, schema);
        List<Table> tables = this.processDataBatches(arrowReader, schemaRoot, operator);
        Table combinedTable = Appender.append(tables, null, (Context)Belt.defaultContext());
        return new IOTable(combinedTable);
    }

    private boolean isSchemaEmpty(VectorSchemaRoot schemaRoot) {
        if (schemaRoot == null || schemaRoot.getSchema().getFields().isEmpty()) {
            LogService.getRoot().log(Level.INFO, "No schema found in Arrow file. Returning an entirely empty table.");
            return true;
        }
        return false;
    }

    private IOObject createEmptyTable() {
        TableBuilder tableBuilder = Builders.newTableBuilder((int)0);
        return new IOTable(tableBuilder.build(Belt.defaultContext()));
    }

    private IOObject createEmptyTableWithHeaders(Schema schema) {
        LogService.getRoot().log(Level.INFO, "No data batches found. Creating an empty table with headers only.");
        TableBuilder tableBuilder = Builders.newTableBuilder((int)0);
        for (Field field : schema.getFields()) {
            tableBuilder.add(field.getName(), (Column)Buffers.nominalBuffer((int)0, (int)0).toColumn());
        }
        return new IOTable(tableBuilder.build(Belt.defaultContext()));
    }

    private void processDictionaries(ArrowStreamReader arrowReader, Schema schema) throws IOException {
        Map<Long, Dictionary> dictionariesMap = arrowReader.getDictionaryVectors();
        Converters.INSTANCE.readDictionaries(schema, dictionariesMap);
    }

    private List<Table> processDataBatches(ArrowStreamReader arrowReader, VectorSchemaRoot schemaRoot, Operator operator) throws UserError, IOException {
        ArrayList<Table> tables = new ArrayList<Table>();
        int batchCount = 0;
        do {
            ++batchCount;
            TableBuilder tableBuilder = Builders.newTableBuilder((int)schemaRoot.getRowCount());
            this.processBatch(schemaRoot, tableBuilder, operator);
            Table table = tableBuilder.build(Belt.defaultContext());
            tables.add(table);
        } while (arrowReader.loadNextBatch());
        LogService.getRoot().log(Level.INFO, String.format("All data batches processed. Total batches: %d", batchCount));
        return tables;
    }

    private void processBatch(VectorSchemaRoot schemaRoot, TableBuilder tableBuilder, Operator operator) throws UserError {
        for (FieldVector vector : schemaRoot.getFieldVectors()) {
            Field field = vector.getField();
            this.readFieldBatch(vector, tableBuilder);
            this.addFieldMetadata(field, tableBuilder, operator);
        }
    }

    private void readFieldBatch(FieldVector vector, TableBuilder tableBuilder) {
        try {
            Converters.INSTANCE.readBatch(vector, tableBuilder);
        }
        catch (IllegalArgumentException e) {
            Field field = vector.getField();
            LogService.getRoot().log(Level.INFO, String.format("Unknown column type for field %s, %s", field.getName(), field.getFieldType().getType()));
            throw new IllegalArgumentException("Unknown column type: " + field.getFieldType().getType(), e);
        }
    }

    private void addFieldMetadata(Field field, TableBuilder tableBuilder, Operator operator) throws UserError {
        Map<String, String> metadata = field.getMetadata();
        if (metadata.isEmpty()) {
            return;
        }
        if (metadata.containsKey("rm_role")) {
            this.setColumnRole(field, metadata.get("rm_role"), tableBuilder, operator);
        }
        if (metadata.containsKey("rm_annotation")) {
            this.setColumnAnnotation(field, metadata.get("rm_annotation"), tableBuilder);
        }
        if (metadata.containsKey("rm_reference")) {
            this.setColumnReference(field, metadata.get("rm_reference"), tableBuilder);
        }
    }

    private void setColumnRole(Field field, String roleValue, TableBuilder tableBuilder, Operator operator) throws UserError {
        LogService.getRoot().log(Level.INFO, String.format("Setting metadata 'rm_role' for field %s: %s", field.getName(), roleValue));
        try {
            ColumnRole role = ColumnRole.valueOf((String)roleValue.toUpperCase());
            tableBuilder.addMetaData(field.getName(), (ColumnMetaData)role);
        }
        catch (IllegalArgumentException e) {
            LogService.getRoot().log(Level.WARNING, String.format("Invalid rm_role '%s' for field '%s'.", roleValue, field.getName()));
            throw new UserError(operator, "python_scripting.failure.invalid_role", new Object[]{roleValue, e.getMessage()});
        }
    }

    private void setColumnAnnotation(Field field, String annotationValue, TableBuilder tableBuilder) {
        LogService.getRoot().log(Level.INFO, String.format("Setting metadata 'rm_annotation' for field %s: %s", field.getName(), annotationValue));
        tableBuilder.addMetaData(field.getName(), (ColumnMetaData)new ColumnAnnotation(annotationValue));
    }

    private void setColumnReference(Field field, String referenceValue, TableBuilder tableBuilder) {
        LogService.getRoot().log(Level.INFO, String.format("Setting metadata 'rm_reference' for field %s: %s", field.getName(), referenceValue));
        tableBuilder.addMetaData(field.getName(), (ColumnMetaData)new ColumnReference(referenceValue));
    }

    @Override
    public String[] getDeserializableFileExtensions() {
        return new String[]{"arrow"};
    }
}

