/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.core.concurrency.ConcurrencyContext;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.extension.pythonscripting.serialization.arrow.ArrowWriter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.studio.internal.Resources;
import com.rapidminer.tools.belt.BeltConversionTools;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class TabularDataToArrowSerializer
implements Serializer {
    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"arrow"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof IOTable || resource instanceof ExampleSet;
    }

    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator op) throws IOException, ProcessStoppedException, UserError {
        this.checkIfCanHandle(resource);
        this.checkNumberOfStreams(streams);
        IOTable table = this.convertToIOTable(resource, op);
        ArrowWriter arrowWriter = new ArrowWriter();
        arrowWriter.setTable(table.getTable());
        arrowWriter.writeArrowToStream(streams[0]);
        arrowWriter.close();
    }

    @Override
    public void serialize(IOObject resource, String filePathWithoutExtension, @Nullable Operator op) throws IOException, ProcessStoppedException, UserError {
        this.checkIfCanHandle(resource);
        IOTable table = this.convertToIOTable(resource, op);
        String fileExtension = this.getPrimarySerializedFileExtension();
        Path fullFilePath = Paths.get(filePathWithoutExtension + "." + fileExtension, new String[0]);
        ArrowWriter arrowWriter = new ArrowWriter();
        arrowWriter.setTable(table.getTable());
        arrowWriter.writeArrowToFile(fullFilePath);
        arrowWriter.close();
    }

    private IOTable convertToIOTable(IOObject resource, @Nullable Operator operator) {
        if (resource instanceof ExampleSet) {
            IOTable table = BeltConversionTools.asIOTableOrNull((IOObject)resource, (ConcurrencyContext)Resources.getConcurrencyContext((Operator)operator));
            if (table == null) {
                throw new IllegalArgumentException("Failed to convert ExampleSet to IOTable.");
            }
            return table;
        }
        if (resource instanceof IOTable) {
            return (IOTable)resource;
        }
        throw new IllegalArgumentException("Unsupported IOObject type: " + resource.getClass().getCanonicalName());
    }
}

