/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NumericBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.reader.NumericReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public abstract class AbstractFloatingPointConverter<V extends FieldVector>
implements Converter {
    private final ArrowType type;
    private final Class<V> vectorClass;

    protected AbstractFloatingPointConverter(ArrowType type, Class<V> vectorClass) {
        this.type = type;
        this.vectorClass = vectorClass;
    }

    @Override
    public boolean canRead(Field field) {
        return field.getType().equals(this.type);
    }

    @Override
    public boolean canWrite(Column column, Field field) {
        return (ColumnType.REAL.equals((Object)column.type()) || ColumnType.INTEGER_53_BIT.equals((Object)column.type())) && field.getType().equals(this.type);
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        FieldVector vector = (FieldVector)this.vectorClass.cast(vec);
        NumericBuffer realBuffer = Buffers.realBuffer((int)vector.getValueCount(), (boolean)false);
        for (int i = 0; i < vector.getValueCount(); ++i) {
            if (!vector.isNull(i)) {
                realBuffer.set(i, this.getFloatingPointValue(vector, i));
                continue;
            }
            realBuffer.set(i, Double.NaN);
        }
        tableBuilder.add(vector.getField().getName(), realBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column column, FieldVector vec, int offset, int nRows) {
        FieldVector vector = (FieldVector)this.vectorClass.cast(vec);
        NumericReader reader = Readers.numericReader((Column)column);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            double rawValue = reader.read();
            if (Double.isNaN(rawValue)) {
                vector.setNull(i);
                continue;
            }
            this.setFloatingPointValue(vector, i, rawValue);
        }
    }

    protected abstract double getFloatingPointValue(V var1, int var2);

    protected abstract void setFloatingPointValue(V var1, int var2, double var3);
}

