/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NumericBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.reader.NumericReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public abstract class AbstractIntegerConverter<V extends FieldVector>
implements Converter {
    private final ArrowType type;
    private final Class<V> vectorClass;

    protected AbstractIntegerConverter(ArrowType type, Class<V> vectorClass) {
        this.type = type;
        this.vectorClass = vectorClass;
    }

    @Override
    public boolean canRead(Field field) {
        return field.getType().equals(this.type) && field.getDictionary() == null;
    }

    @Override
    public boolean canWrite(Column column, Field field) {
        return ColumnType.INTEGER_53_BIT.equals((Object)column.type()) && field.getType().equals(this.type);
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        FieldVector vector = (FieldVector)this.vectorClass.cast(vec);
        NumericBuffer intBuffer = Buffers.integer53BitBuffer((int)vector.getValueCount(), (boolean)false);
        for (int i = 0; i < vector.getValueCount(); ++i) {
            if (!vector.isNull(i)) {
                intBuffer.set(i, (double)this.getIntegerValue(vector, i));
                continue;
            }
            intBuffer.set(i, Double.NaN);
        }
        tableBuilder.add(vector.getField().getName(), intBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column column, FieldVector vec, int offset, int nRows) {
        FieldVector vector = (FieldVector)this.vectorClass.cast(vec);
        NumericReader reader = Readers.numericReader((Column)column);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            double rawValue = reader.read();
            if (Double.isNaN(rawValue)) {
                vector.setNull(i);
                continue;
            }
            this.setIntegerValue(vector, i, Math.round(rawValue));
        }
    }

    protected abstract long getIntegerValue(V var1, int var2);

    protected abstract void setIntegerValue(V var1, int var2, long var3);
}

