/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NominalBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.reader.NumericReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public abstract class AbstractNominalConverter<V extends FieldVector>
implements Converter {
    protected final ArrowType type;
    protected final Map<String, NominalMapping> dictionaries;
    protected final Class<V> vectorClass;

    protected AbstractNominalConverter(ArrowType type, Map<String, NominalMapping> dictionaries, Class<V> vectorClass) {
        this.type = type;
        this.dictionaries = dictionaries;
        this.vectorClass = vectorClass;
    }

    @Override
    public boolean canRead(Field field) {
        return field.getType().equals(this.type) && field.getDictionary() != null;
    }

    @Override
    public boolean canWrite(Column column, Field field) {
        return ColumnType.NOMINAL.equals((Object)column.type()) && field.getType().equals(this.type);
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        FieldVector vector = (FieldVector)this.vectorClass.cast(vec);
        String fieldName = vector.getField().getName();
        NominalMapping nominalMapping = this.dictionaries.get(fieldName);
        if (nominalMapping == null) {
            throw new IllegalStateException("No nominal mapping found for field: " + fieldName);
        }
        List mappingValues = nominalMapping.getValues();
        NominalBuffer nominalBuffer = Buffers.nominalBuffer((int)vector.getValueCount(), (int)mappingValues.size());
        for (int i = 0; i < vector.getValueCount(); ++i) {
            if (!vector.isNull(i)) {
                int index = this.getIntegerValue(vector, i);
                if (index >= 0 && index < mappingValues.size()) {
                    nominalBuffer.set(i, (String)mappingValues.get(index));
                    continue;
                }
                nominalBuffer.set(i, null);
                continue;
            }
            nominalBuffer.set(i, null);
        }
        tableBuilder.add(fieldName, (Column)nominalBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column column, FieldVector vec, int offset, int nRows) {
        FieldVector vector = (FieldVector)this.vectorClass.cast(vec);
        NumericReader reader = Readers.numericReader((Column)column);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            double rawValue = reader.read() - 1.0;
            if (Double.isNaN(rawValue)) {
                vector.setNull(i);
                continue;
            }
            int index = (int)rawValue;
            this.setIntegerValue(vector, i, index);
        }
    }

    protected abstract int getIntegerValue(V var1, int var2);

    protected abstract void setIntegerValue(V var1, int var2, int var3);
}

