/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NominalBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class BoolConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        return field.getType() instanceof ArrowType.Bool && field.getDictionary() == null;
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return false;
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        BitVector vector = (BitVector)vec;
        List<String> mappingValues = Arrays.asList("False", "True");
        NominalBuffer nominalBuffer = Buffers.nominalBuffer((int)vector.getValueCount(), (int)mappingValues.size());
        for (int i = 0; i < vector.getValueCount(); ++i) {
            if (!vector.isNull(i)) {
                int bitValue = vector.get(i);
                String value = mappingValues.get(bitValue);
                nominalBuffer.set(i, value);
                continue;
            }
            nominalBuffer.set(i, null);
        }
        tableBuilder.add(vector.getField().getName(), (Column)nominalBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        throw new UnsupportedOperationException("BoolConverter does not support write operation");
    }
}

