/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.BigIntConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.BoolConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.DateDayConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.DateTimeNanoConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.DateTimeSecConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.IntConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.IntNominalConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.RealArrayConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.RealConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.SmallIntConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.SmallIntNominalConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TextConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TextListConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TextNominalSpecialConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TextSetConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TimeConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TinyIntConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.TinyIntNominalConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt1Converter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt1NominalConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt2Converter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt2NominalConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt4Converter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt4NominalConverter;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.UInt8Converter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public enum Converters {
    INSTANCE;

    private final Map<String, NominalMapping> dictionaries = new HashMap<String, NominalMapping>();
    private final List<Converter> converterList = new ArrayList<Converter>();

    private Converters() {
        this.addConverters(new TextConverter(), new TextNominalSpecialConverter(), new TextListConverter(), new TextSetConverter());
        this.addConverters(new RealConverter(), new RealArrayConverter(), new BoolConverter(), new BigIntConverter(), new IntConverter(), new SmallIntConverter(), new UInt1Converter(), new UInt2Converter(), new UInt4Converter(), new UInt8Converter(), new TinyIntConverter());
        this.addConverters(new IntNominalConverter(this.dictionaries), new SmallIntNominalConverter(this.dictionaries), new UInt1NominalConverter(this.dictionaries), new UInt2NominalConverter(this.dictionaries), new UInt4NominalConverter(this.dictionaries), new TinyIntNominalConverter(this.dictionaries));
        this.addConverters(new DateTimeSecConverter(), new DateTimeNanoConverter(), new TimeConverter(), new DateDayConverter());
    }

    private void addConverters(Converter ... converters) {
        Collections.addAll(this.converterList, converters);
    }

    public void readDictionaries(Schema schema, Map<Long, Dictionary> dictionariesMap) {
        this.dictionaries.clear();
        for (Field field : schema.getFields()) {
            this.readDictionary(field, dictionariesMap);
        }
    }

    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        for (Converter converter : this.converterList) {
            if (!converter.canRead(vec.getField())) continue;
            converter.readBatch(vec, tableBuilder);
            return;
        }
        throw new IllegalArgumentException("No converter found for reading " + vec.getField());
    }

    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        for (Converter converter : this.converterList) {
            if (!converter.canWrite(col, vec.getField())) continue;
            converter.writeBatch(col, vec, offset, nRows);
            return;
        }
        throw new IllegalArgumentException("No converter found for writing column of type " + col.type());
    }

    private void readDictionary(Field field, Map<Long, Dictionary> dictionariesMap) {
        long dictId;
        Dictionary dictionary;
        DictionaryEncoding dictEncoding = field.getDictionary();
        if (dictEncoding != null && (dictionary = dictionariesMap.get(dictId = dictEncoding.getId())) != null) {
            FieldVector vector = dictionary.getVector();
            PolynominalMapping mapping = new PolynominalMapping();
            int valueCount = vector.getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                Object value = vector.getObject(i);
                if (value != null) {
                    mapping.mapString(value.toString());
                    continue;
                }
                mapping.mapString("");
            }
            this.dictionaries.put(field.getName(), (NominalMapping)mapping);
        }
        for (Field childField : field.getChildren()) {
            this.readDictionary(childField, dictionariesMap);
        }
    }
}

