/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.DateTimeBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class DateDayConverter
implements Converter {
    private final ArrowType type = Types.MinorType.DATEDAY.getType();

    @Override
    public boolean canRead(Field field) {
        return field.getType().equals(this.type) && field.getDictionary() == null;
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return false;
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        DateDayVector vector = (DateDayVector)vec;
        DateTimeBuffer dateTimeBuffer = Buffers.dateTimeBuffer((int)vector.getValueCount(), (boolean)false);
        String fieldName = vector.getField().getName();
        for (int i = 0; i < vector.getValueCount(); ++i) {
            if (!vector.isNull(i)) {
                dateTimeBuffer.set(i, (long)vector.get(i) * 86400L);
                continue;
            }
            dateTimeBuffer.set(i, null);
        }
        tableBuilder.add(fieldName, (Column)dateTimeBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        throw new UnsupportedOperationException(String.format("%s does not support write operation", this.getClass().getName()));
    }
}

