/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.DateTimeBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.column.DateTimeColumn;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.time.Instant;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class DateTimeNanoConverter
implements Converter {
    private static final long NANO = 1000000000L;

    @Override
    public boolean canRead(Field field) {
        ArrowType type = field.getFieldType().getType();
        if (type instanceof ArrowType.Timestamp) {
            ArrowType.Timestamp timestampType = (ArrowType.Timestamp)type;
            return timestampType.getUnit() == TimeUnit.NANOSECOND;
        }
        return false;
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return ColumnType.DATETIME.equals((Object)col.type()) && ((DateTimeColumn)col).hasSubSecondPrecision();
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        DateTimeBuffer dateTimeBuffer = Buffers.dateTimeBuffer((int)vec.getValueCount(), (boolean)true);
        String fieldName = vec.getField().getName();
        if (vec instanceof TimeStampNanoVector) {
            TimeStampNanoVector vector = (TimeStampNanoVector)vec;
            for (int i = 0; i < vector.getValueCount(); ++i) {
                if (!vector.isNull(i)) {
                    long dateTimeElement = vector.get(i);
                    if (dateTimeElement == 0L) {
                        dateTimeBuffer.set(i, 0L);
                        continue;
                    }
                    dateTimeBuffer.set(i, dateTimeElement / 1000000000L, (int)(dateTimeElement % 1000000000L));
                    continue;
                }
                dateTimeBuffer.set(i, null);
            }
            tableBuilder.add(fieldName, (Column)dateTimeBuffer.toColumn());
        } else if (vec instanceof TimeStampNanoTZVector) {
            TimeStampNanoTZVector vector = (TimeStampNanoTZVector)vec;
            for (int i = 0; i < vector.getValueCount(); ++i) {
                if (!vector.isNull(i)) {
                    long dateTimeElement = vector.get(i);
                    if (dateTimeElement == 0L) {
                        dateTimeBuffer.set(i, 0L);
                        continue;
                    }
                    dateTimeBuffer.set(i, dateTimeElement / 1000000000L, (int)(dateTimeElement % 1000000000L));
                    continue;
                }
                dateTimeBuffer.set(i, null);
            }
            tableBuilder.add(fieldName, (Column)dateTimeBuffer.toColumn());
        } else {
            throw new IllegalArgumentException("Unsupported vector type: " + vec.getClass().getName());
        }
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        TimeStampNanoTZVector vector = (TimeStampNanoTZVector)vec;
        ObjectReader reader = Readers.objectReader((Column)col, Instant.class);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            Instant rawValue = (Instant)reader.read();
            if (rawValue != null) {
                long timestampValue = rawValue.getEpochSecond() * 1000000000L + (long)rawValue.getNano();
                vector.set(i, 1, timestampValue);
                continue;
            }
            vector.setNull(i);
        }
    }
}

