/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.DateTimeBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.column.DateTimeColumn;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.time.Instant;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class DateTimeSecConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        ArrowType arrowType = field.getFieldType().getType();
        if (arrowType instanceof ArrowType.Timestamp) {
            ArrowType.Timestamp timestampType = (ArrowType.Timestamp)arrowType;
            return timestampType.getUnit() == TimeUnit.SECOND;
        }
        return false;
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return ColumnType.DATETIME.equals((Object)col.type()) && !((DateTimeColumn)col).hasSubSecondPrecision();
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        DateTimeBuffer dateTimeBuffer = Buffers.dateTimeBuffer((int)vec.getValueCount(), (boolean)false);
        String fieldName = vec.getField().getName();
        if (vec instanceof TimeStampSecVector) {
            TimeStampSecVector vector = (TimeStampSecVector)vec;
            for (int i = 0; i < vector.getValueCount(); ++i) {
                if (!vector.isNull(i)) {
                    dateTimeBuffer.set(i, vector.get(i));
                    continue;
                }
                dateTimeBuffer.set(i, null);
            }
            tableBuilder.add(fieldName, (Column)dateTimeBuffer.toColumn());
        } else if (vec instanceof TimeStampSecTZVector) {
            TimeStampSecTZVector vector = (TimeStampSecTZVector)vec;
            for (int i = 0; i < vector.getValueCount(); ++i) {
                if (!vector.isNull(i)) {
                    dateTimeBuffer.set(i, vector.get(i));
                    continue;
                }
                dateTimeBuffer.set(i, null);
            }
            tableBuilder.add(fieldName, (Column)dateTimeBuffer.toColumn());
        } else {
            throw new IllegalArgumentException("Unsupported vector type: " + vec.getClass().getName());
        }
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        TimeStampSecTZVector vector = (TimeStampSecTZVector)vec;
        ObjectReader reader = Readers.objectReader((Column)col, Instant.class);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            Instant rawValue = (Instant)reader.read();
            if (rawValue != null) {
                vector.set(i, 1, rawValue.getEpochSecond());
                continue;
            }
            vector.setNull(i);
        }
    }
}

