/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.ObjectBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.column.type.RealArray;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class RealArrayConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        return field.getType() instanceof ArrowType.List && Converter.isFieldChildType(field, ArrowType.FloatingPoint.class);
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return ColumnType.REALARRAY.equals((Object)col.type());
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        ListVector vector = (ListVector)vec;
        ObjectBuffer realArrayBuffer = Buffers.realarrayBuffer((int)vector.getValueCount());
        for (int i = 0; i < vector.getValueCount(); ++i) {
            ArrayList elements = (ArrayList)vector.getObject(i);
            RealArray r = elements != null ? new RealArray(elements.stream().mapToDouble(Double::doubleValue).toArray()) : null;
            realArrayBuffer.set(i, r);
        }
        tableBuilder.add(vector.getField().getName(), realArrayBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        ListVector vector = (ListVector)vec;
        ObjectReader reader = Readers.objectReader((Column)col, RealArray.class);
        Float8Vector floatVector = (Float8Vector)vector.addOrGetVector(FieldType.nullable(Types.MinorType.FLOAT8.getType())).getVector();
        int elementIndex = 0;
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            vector.startNewValue(i);
            RealArray value = (RealArray)reader.read();
            int columnIndex = 0;
            PrimitiveIterator.OfDouble j = value.iterator();
            while (j.hasNext()) {
                floatVector.setSafe(elementIndex, (Double)j.next());
                ++elementIndex;
                ++columnIndex;
            }
            vector.endValue(i, columnIndex);
        }
    }
}

