/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.ObjectBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class TextConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        return field.getType() instanceof ArrowType.Utf8 && Column.TypeId.TEXT.toString().equalsIgnoreCase(field.getMetadata().get("rm_type"));
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return ColumnType.TEXT.equals((Object)col.type()) || ColumnType.NOMINAL.equals((Object)col.type()) && field.getType().equals(new ArrowType.Utf8());
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        VarCharVector vector = (VarCharVector)vec;
        int valueCount = vector.getValueCount();
        ObjectBuffer textBuffer = Buffers.textBuffer((int)valueCount);
        for (int i = 0; i < valueCount; ++i) {
            if (vector.isNull(i)) continue;
            String value = new String(vector.get(i), StandardCharsets.UTF_8);
            textBuffer.set(i, (Object)value);
        }
        tableBuilder.add(vector.getField().getName(), textBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        VarCharVector vector = (VarCharVector)vec;
        ObjectReader reader = Readers.objectReader((Column)col, String.class);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            String value = (String)reader.read();
            if (value != null) {
                vector.setSafe(i, value.getBytes(StandardCharsets.UTF_8));
                continue;
            }
            vector.setNull(i);
        }
    }
}

