/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NominalBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class TextNominalSpecialConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        String rmType = field.getMetadata().get("rm_type");
        return field.getType() instanceof ArrowType.Utf8 && (Column.TypeId.NOMINAL.toString().equalsIgnoreCase(rmType) || "polynominal".equalsIgnoreCase(rmType) || "binominal".equalsIgnoreCase(rmType) || field.getMetadata().isEmpty());
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return false;
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        VarCharVector varCharVector = (VarCharVector)vec;
        int rowCount = varCharVector.getValueCount();
        NominalBuffer nominalBuffer = Buffers.nominalBuffer((int)rowCount, (int)rowCount);
        for (int i = 0; i < rowCount; ++i) {
            if (!varCharVector.isNull(i)) {
                byte[] bytes = varCharVector.get(i);
                String value = new String(bytes, StandardCharsets.UTF_8);
                nominalBuffer.set(i, value);
                continue;
            }
            nominalBuffer.set(i, null);
        }
        tableBuilder.add(varCharVector.getField().getName(), (Column)nominalBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        throw new UnsupportedOperationException(String.format("%s does not support write operation", this.getClass().getName()));
    }
}

