/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.ObjectBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.column.type.TextSet;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;

public class TextSetConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        return field.getType() instanceof ArrowType.List && Converter.isFieldChildType(field, ArrowType.Utf8.class) && Column.TypeId.TEXT_SET.toString().equals(field.getMetadata().get("rm_type"));
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return ColumnType.TEXTSET.equals((Object)col.type());
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        ListVector vector = (ListVector)vec;
        ObjectBuffer textSetBuffer = Buffers.textsetBuffer((int)vector.getValueCount());
        for (int i = 0; i < vector.getValueCount(); ++i) {
            ArrayList elements = (ArrayList)vector.getObject(i);
            TextSet t = elements != null ? new TextSet((Collection)elements.stream().map(Text::toString).collect(Collectors.toList())) : null;
            textSetBuffer.set(i, t);
        }
        tableBuilder.add(vector.getField().getName(), textSetBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        ListVector vector = (ListVector)vec;
        ObjectReader reader = Readers.objectReader((Column)col, TextSet.class);
        VarCharVector varCharVector = (VarCharVector)vector.addOrGetVector(FieldType.nullable(Types.MinorType.VARCHAR.getType())).getVector();
        int elementIndex = 0;
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            vector.startNewValue(i);
            TextSet value = (TextSet)reader.read();
            int columnIndex = 0;
            for (String v : value) {
                varCharVector.setSafe(elementIndex, new Text(v));
                ++elementIndex;
                ++columnIndex;
            }
            vector.endValue(i, columnIndex);
        }
    }
}

