/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow.convert;

import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.TimeBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.extension.pythonscripting.serialization.arrow.convert.Converter;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class TimeConverter
implements Converter {
    @Override
    public boolean canRead(Field field) {
        return field.getFieldType().getType().equals(new ArrowType.Duration(TimeUnit.NANOSECOND));
    }

    @Override
    public boolean canWrite(Column col, Field field) {
        return ColumnType.TIME.equals((Object)col.type());
    }

    @Override
    public void readBatch(FieldVector vec, TableBuilder tableBuilder) {
        DurationVector vector = (DurationVector)vec;
        TimeBuffer timeBuffer = Buffers.timeBuffer((int)vector.getValueCount(), (boolean)false);
        String fieldName = vector.getField().getName();
        for (int i = 0; i < vector.getValueCount(); ++i) {
            if (!vector.isNull(i)) {
                long nanos = vector.getObject(i).toNanos();
                LocalTime time = LocalTime.ofNanoOfDay(nanos);
                timeBuffer.set(i, time);
                continue;
            }
            timeBuffer.set(i, null);
        }
        tableBuilder.add(fieldName, (Column)timeBuffer.toColumn());
    }

    @Override
    public void writeBatch(Column col, FieldVector vec, int offset, int nRows) {
        DurationVector vector = (DurationVector)vec;
        ObjectReader reader = Readers.objectReader((Column)col, LocalTime.class);
        reader.setPosition(offset - 1);
        for (int i = 0; i < nRows; ++i) {
            LocalTime rawValue = (LocalTime)reader.read();
            if (rawValue != null) {
                long nanos = rawValue.getLong(ChronoField.NANO_OF_DAY);
                vector.set(i, 1, nanos);
                continue;
            }
            vector.setNull(i);
        }
    }
}

