/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.tools;

import com.rapidminer.extension.pythonscripting.gui.dialog.CodeCell;
import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScriptingTools {
    private static final String NB_TAG_METADATA = "metadata";
    private static final String NB_TAG_TAGS = "tags";
    private static final String NB_TAG_CODE_CELL_TYPE = "code";
    private static final String NB_TAG_CELL_TYPE = "cell_type";
    private static final String NB_TAG_V4_SOURCE = "source";
    private static final String NB_TAG_V3_SOURCE = "input";
    private static final String NB_TAG_CELLS = "cells";
    private static final int READER_BUFFER_SIZE = 1024;
    private static final Pattern PATTERN_MAGIC_COMMAND = Pattern.compile("^\\s*(%|!).+$", 8);

    private ScriptingTools() {
    }

    private static String readToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[1024];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        reader.close();
        return buffer.toString();
    }

    private static boolean isCellRequired(JSONObject cell, String tagRegex) {
        if ("".equals(tagRegex)) {
            return true;
        }
        Pattern pattern = Pattern.compile(tagRegex);
        if (cell.has(NB_TAG_METADATA)) {
            JSONObject metadata = cell.getJSONObject(NB_TAG_METADATA);
            JSONArray currentTags = metadata.optJSONArray(NB_TAG_TAGS);
            if (currentTags == null || currentTags.length() == 0) {
                return pattern.matcher("").find();
            }
            for (int i = 0; i < currentTags.length(); ++i) {
                if (!pattern.matcher(currentTags.getString(i)).find()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCodeCell(JSONObject cell) {
        return NB_TAG_CODE_CELL_TYPE.equals(cell.getString(NB_TAG_CELL_TYPE));
    }

    private static String cellSource(JSONObject cell) {
        StringBuilder cc = new StringBuilder();
        JSONArray lines = cell.has(NB_TAG_V4_SOURCE) ? cell.getJSONArray(NB_TAG_V4_SOURCE) : cell.getJSONArray(NB_TAG_V3_SOURCE);
        for (int i = 0; i < lines.length(); ++i) {
            cc.append(lines.getString(i));
        }
        return cc.toString();
    }

    private static Set<String> cellTags(JSONObject cell) {
        JSONObject metadata;
        HashSet<String> tags = new HashSet<String>();
        if (cell.has(NB_TAG_METADATA) && (metadata = cell.getJSONObject(NB_TAG_METADATA)).has(NB_TAG_TAGS)) {
            JSONArray jsonTags = metadata.getJSONArray(NB_TAG_TAGS);
            for (int i = 0; i < jsonTags.length(); ++i) {
                tags.add(jsonTags.getString(i));
            }
        }
        return tags;
    }

    public static String readNotebook(Reader reader, String tagRegex) throws IOException {
        StringBuilder pyCode = new StringBuilder();
        pyCode.append("\n#Python code generated by RapidMiner Python Scripting Extension\n");
        int cellNumber = 1;
        try {
            for (CodeCell cell : ScriptingTools.readNotebookAsCodeCell(reader, tagRegex)) {
                pyCode.append("\n# Code of cell #").append(cellNumber).append("\n");
                pyCode.append(cell.getSource());
                ++cellNumber;
            }
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return pyCode.toString();
    }

    private static List<CodeCell> readNotebookAsCodeCell(Reader reader, String tagRegex) throws IOException {
        LogService.getRoot().finest("Reading notebook from stream, using '" + tagRegex + "' tags.");
        ArrayList<CodeCell> result = new ArrayList<CodeCell>();
        JSONObject root = new JSONObject(ScriptingTools.readToString(reader));
        JSONArray cells = root.getJSONArray(NB_TAG_CELLS);
        for (int i = 0; i < cells.length(); ++i) {
            String source;
            JSONObject cell = cells.getJSONObject(i);
            if (!ScriptingTools.isCodeCell(cell) || !ScriptingTools.isCellRequired(cell, tagRegex) || (source = ScriptingTools.cellSource(cell)).trim().isEmpty()) continue;
            result.add(new CodeCell(source, ScriptingTools.cellTags(cell)));
        }
        LogService.getRoot().finest("Read notebook from stream. Kept '" + result.size() + "' code cell from the total '" + cells.length() + "' cells.");
        return result;
    }

    public static List<CodeCell> readNotebook(Reader reader) throws IOException {
        return ScriptingTools.readNotebookAsCodeCell(reader, "");
    }

    private static Set<String> getTagsFromCell(JSONObject cell) {
        JSONObject metadata;
        HashSet<String> result = new HashSet<String>();
        if (cell.has(NB_TAG_METADATA) && (metadata = cell.getJSONObject(NB_TAG_METADATA)).has(NB_TAG_TAGS)) {
            JSONArray tags = metadata.getJSONArray(NB_TAG_TAGS);
            for (int i = 0; i < tags.length(); ++i) {
                result.add(tags.getString(i));
            }
        }
        return result;
    }

    public static Set<String> readTagsFromNotebook(Reader reader) throws IOException {
        HashSet<String> tags = new HashSet<String>();
        try {
            JSONObject root = new JSONObject(ScriptingTools.readToString(reader));
            JSONArray cells = root.getJSONArray(NB_TAG_CELLS);
            for (int i = 0; i < cells.length(); ++i) {
                JSONObject cell = cells.getJSONObject(i);
                tags.addAll(ScriptingTools.getTagsFromCell(cell));
            }
            LogService.getRoot().finest("Read notebook from stream to get the set of tags. Found " + tags.size() + " tags in total.");
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return tags;
    }

    public static boolean hasMagicCommands(String script) {
        return PATTERN_MAGIC_COMMAND.matcher(script).find();
    }
}

