/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.extensions;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import com.rapidminer.tools.update.internal.UpdateManagerRegistry;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.logging.Level;

public class IncompatibleExtension
extends Observable {
    private final Plugin.BrokenPlugin plugin;
    private final boolean managed;
    private Fix fix;
    private List<Fix> availableFixes;

    public IncompatibleExtension(Plugin.BrokenPlugin plugin) {
        this.plugin = plugin;
        this.managed = ManagedExtension.get((String)plugin.getPlugin().getExtensionId()) != null;
        this.fix = Fix.IGNORE;
        this.availableFixes = Collections.emptyList();
    }

    public boolean updateFixes() {
        VersionNumber currentVersion = this.getPlugin().getPlugin().getTechnicalVersion();
        String latestVersionString = null;
        boolean marketplaceAvailable = true;
        try {
            latestVersionString = UpdateManagerRegistry.INSTANCE.get().getLatestVersion(this.getId(), "ANY", PlatformUtilities.getTechnicalReleaseVersion());
        }
        catch (IOException | URISyntaxException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to communicate with marketplace", e);
            marketplaceAvailable = false;
        }
        VersionNumber latestVersion = null;
        if (latestVersionString != null) {
            try {
                latestVersion = new VersionNumber(latestVersionString);
            }
            catch (VersionNumber.VersionNumberException e) {
                LogService.getRoot().log(Level.WARNING, "Unexpected error checking incompatible extensions", e);
            }
        }
        this.availableFixes = new ArrayList<Fix>();
        if (currentVersion != null && latestVersion != null && latestVersion.isAbove(currentVersion) && !Plugin.isExtensionVersionBlacklisted((String)this.plugin.getPlugin().getExtensionId(), (VersionNumber)latestVersion)) {
            this.availableFixes.add(Fix.UPDATE);
        }
        if (this.isManaged()) {
            this.availableFixes.add(Fix.REMOVE);
        }
        this.availableFixes.add(Fix.IGNORE);
        this.fix = marketplaceAvailable ? this.availableFixes.get(0) : Fix.IGNORE;
        this.setChanged();
        this.notifyObservers((Object)ExtensionEvent.CHECK_COMPLETED);
        return marketplaceAvailable;
    }

    public Plugin.BrokenPlugin getPlugin() {
        return this.plugin;
    }

    public String getId() {
        return this.plugin.getPlugin().getExtensionId();
    }

    public boolean isManaged() {
        return this.managed;
    }

    public Fix getSelectedFix() {
        return this.fix;
    }

    public List<Fix> getAvailableFixes() {
        return Collections.unmodifiableList(this.availableFixes);
    }

    public void setFix(Fix fix) {
        if (this.fix != fix) {
            this.fix = fix;
            this.setChanged();
            this.notifyObservers((Object)ExtensionEvent.FIX_CHANGED);
        }
    }

    public static enum Fix {
        UPDATE("update"),
        REMOVE("remove"),
        IGNORE("ignore");

        private final String action;

        private Fix(String key) {
            this.action = I18N.getGUILabel((String)("incompatible_extension.action." + key), (Object[])new Object[0]);
        }

        public String toString() {
            return this.action;
        }
    }

    public static enum ExtensionEvent {
        CHECK_COMPLETED,
        FIX_CHANGED;

    }
}

