/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.extensions;

import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.extensions.IncompatibleExtension;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.FixedWidthLabel;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import com.rapidminer.tools.update.internal.UpdateManagerRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class IncompatibleExtensionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JButton ignoreButton;
    private final JButton applyButton;
    private final List<IncompatibleExtension> toRemove;
    private final List<IncompatibleExtension> toUpdate;

    public IncompatibleExtensionsDialog() {
        super((Frame)ApplicationFrame.getApplicationFrame());
        Collection plugins = Plugin.getFailedPlugins();
        final ArrayList<IncompatibleExtension> extensions = new ArrayList<IncompatibleExtension>(plugins.size());
        for (Plugin.BrokenPlugin plugin : plugins) {
            extensions.add(new IncompatibleExtension(plugin));
        }
        this.toRemove = new ArrayList<IncompatibleExtension>(extensions.size());
        this.toUpdate = new ArrayList<IncompatibleExtension>(extensions.size());
        final ProgressThread checkWorker = new ProgressThread("incompatible_extensions.check"){

            public void run() {
                boolean marketplaceAvailable = true;
                for (IncompatibleExtension extension : extensions) {
                    this.checkCancelled();
                    marketplaceAvailable &= extension.updateFixes();
                }
                if (!marketplaceAvailable) {
                    SwingUtilities.invokeLater(() -> SwingTools.showVerySimpleErrorMessage((String)"incompatible_extensions.failed_to_query_market_place", (Object[])new Object[0]));
                }
                this.checkCancelled();
                SwingUtilities.invokeLater(() -> IncompatibleExtensionsDialog.this.applyButton.setEnabled(true));
            }

            public boolean isCancelable() {
                return true;
            }
        };
        final ProgressThread removalWorker = new ProgressThread("incompatible_extensions.remove"){

            public void run() {
                for (IncompatibleExtension extension : IncompatibleExtensionsDialog.this.toRemove) {
                    ManagedExtension.get((String)extension.getId()).uninstallActiveVersion();
                }
            }
        };
        removalWorker.setIndeterminate(true);
        final ProgressThread updateWorker = new ProgressThread("incompatible_extensions.update"){

            public void run() {
                ArrayList<String> packages = new ArrayList<String>(IncompatibleExtensionsDialog.this.toUpdate.size());
                for (IncompatibleExtension extension : IncompatibleExtensionsDialog.this.toUpdate) {
                    packages.add(extension.getId());
                }
                SwingTools.invokeLater(() -> {
                    try {
                        UpdateManagerRegistry.INSTANCE.get().installSelectedPackages(packages);
                    }
                    catch (IOException | URISyntaxException e) {
                        LogService.getRoot().log(Level.SEVERE, "Failed to open marketplace.", e);
                        SwingTools.showVerySimpleErrorMessage((String)"incompatible_extensions.failed_to_open_market_place", (Object[])new Object[0]);
                    }
                });
            }
        };
        updateWorker.setIndeterminate(true);
        ResourceAction ignore = new ResourceAction("incompatible_extensions.ignore", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                IncompatibleExtensionsDialog.this.ignoreButton.setEnabled(false);
                IncompatibleExtensionsDialog.this.applyButton.setEnabled(false);
                checkWorker.cancel();
                IncompatibleExtensionsDialog.this.dispose();
            }
        };
        ResourceAction apply = new ResourceAction("incompatible_extensions.apply", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                IncompatibleExtensionsDialog.this.toRemove.clear();
                IncompatibleExtensionsDialog.this.toUpdate.clear();
                for (IncompatibleExtension extension : extensions) {
                    switch (extension.getSelectedFix()) {
                        case REMOVE: {
                            IncompatibleExtensionsDialog.this.toRemove.add(extension);
                            break;
                        }
                        case UPDATE: {
                            IncompatibleExtensionsDialog.this.toUpdate.add(extension);
                            break;
                        }
                    }
                }
                if (!IncompatibleExtensionsDialog.this.toRemove.isEmpty()) {
                    updateWorker.addDependency(new String[]{removalWorker.getID()});
                    removalWorker.start();
                }
                if (!IncompatibleExtensionsDialog.this.toUpdate.isEmpty()) {
                    updateWorker.start();
                }
                IncompatibleExtensionsDialog.this.dispose();
            }
        };
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                checkWorker.cancel();
            }
        });
        String title = I18N.getGUIMessage((String)"gui.dialog.incompatible_extensions.title", (Object[])new Object[0]);
        String message = I18N.getGUIMessage((String)"gui.dialog.incompatible_extensions.message", (Object[])new Object[0]);
        String icon = I18N.getGUIMessage((String)"gui.dialog.incompatible_extensions.icon", (Object[])new Object[0]);
        JPanel header = new JPanel(new FlowLayout(0, 12, 8));
        header.add(new JLabel(SwingTools.createIcon((String)("48/" + icon))));
        header.add((Component)new FixedWidthLabel(500, message));
        ExtensionList content = new ExtensionList(extensions);
        JPanel buttons = new JPanel(new FlowLayout(2));
        this.applyButton = new JButton((Action)apply);
        this.applyButton.setEnabled(false);
        this.ignoreButton = new JButton((Action)ignore);
        buttons.add(this.applyButton);
        buttons.add(this.ignoreButton);
        this.setTitle(title);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.add((Component)header, "North");
        this.add((Component)((Object)content), "Center");
        this.add((Component)buttons, "South");
        Dimension size = header.getPreferredSize();
        size.width += 8;
        size.height = 300;
        this.setPreferredSize(size);
        this.pack();
        this.setLocationRelativeTo((Component)RapidMinerGUI.getMainFrame());
        checkWorker.start();
    }

    private static class ExtensionList
    extends ExtendedJScrollPane {
        private static final long serialVersionUID = 1L;
        private static final Color PRIMARY_BACKGROUND = Color.WHITE;
        private static final Color SECONDARY_BACKGROUND = new Color(225, 225, 225);
        private static final Border BORDER = BorderFactory.createMatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY);
        private final List<IncompatibleExtension> extensions;

        public ExtensionList(List<IncompatibleExtension> extensions) {
            this.extensions = extensions;
            this.setBorder(BORDER);
            this.getViewport().setView(this.createList());
        }

        private JPanel createList() {
            JPanel list = new JPanel();
            list.setLayout(new GridBagLayout());
            list.setBackground(PRIMARY_BACKGROUND);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            boolean even = true;
            for (IncompatibleExtension extension : this.extensions) {
                ExtensionPanel panel = new ExtensionPanel(extension);
                panel.setBackground(even ? PRIMARY_BACKGROUND : SECONDARY_BACKGROUND);
                list.add((Component)panel, constraints);
                ++constraints.gridy;
                even = !even;
            }
            constraints.fill = 1;
            constraints.weighty = 1.0;
            list.add(Box.createVerticalGlue(), constraints);
            return list;
        }
    }

    private static class ExtensionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final GridBagConstraints ICON_CONSTRAINTS;
        private static final GridBagConstraints LABEL_CONSTRAINTS;
        private static final GridBagConstraints INFO_CONSTRAINTS;
        private static final GridBagConstraints CONTROL_CONSTRAINTS;
        private static final Dimension CONTROL_SIZE;
        private static final Icon UNKNOWN_ICON;
        private static final Icon INFO_ICON;
        private static final Icon WARNING_ICON;
        private JComponent currentControl;
        private final IncompatibleExtension extension;

        ExtensionPanel(IncompatibleExtension extension) {
            this.extension = extension;
            this.setLayout(new GridBagLayout());
            Icon icon = extension.getPlugin().getPlugin().getExtensionIcon();
            if (icon == null) {
                icon = UNKNOWN_ICON;
            }
            this.add((Component)new JLabel(icon), ICON_CONSTRAINTS);
            String name = extension.getPlugin().getPlugin().getName();
            String version = extension.getPlugin().getPlugin().getDisplayVersion().getShortLongVersion();
            ResourceLabel extensionLabel = new ResourceLabel("incompatible_extension", new Object[]{name, version});
            this.add((Component)extensionLabel, LABEL_CONSTRAINTS);
            Plugin.IncompatibilityReason incompatibilityReason = extension.getPlugin().getReason();
            Icon reasonIcon = WARNING_ICON;
            if (incompatibilityReason == Plugin.IncompatibilityReason.BLACKLISTED) {
                reasonIcon = INFO_ICON;
            }
            JLabel reason = new JLabel(incompatibilityReason.getI18nMessage(), reasonIcon, 10);
            reason.setToolTipText(extension.getPlugin().getMessage());
            this.add((Component)reason, INFO_CONSTRAINTS);
            this.showProgressIndicator();
            extension.addObserver((o, arg) -> {
                if (arg == IncompatibleExtension.ExtensionEvent.CHECK_COMPLETED) {
                    IncompatibleExtension incompatibleExtension = (IncompatibleExtension)o;
                    List<IncompatibleExtension.Fix> fixes = incompatibleExtension.getAvailableFixes();
                    SwingUtilities.invokeLater(() -> this.showFixes(fixes.toArray(new IncompatibleExtension.Fix[0]), incompatibleExtension.getSelectedFix()));
                }
            });
        }

        public void showProgressIndicator() {
            if (this.currentControl != null) {
                this.remove(this.currentControl);
            }
            JProgressBar progressBar = new JProgressBar();
            progressBar.setPreferredSize(CONTROL_SIZE);
            progressBar.setIndeterminate(true);
            this.add((Component)progressBar, CONTROL_CONSTRAINTS);
            this.currentControl = progressBar;
            this.revalidate();
        }

        public void showFixes(IncompatibleExtension.Fix[] fixes, IncompatibleExtension.Fix selectedFix) {
            if (this.currentControl != null) {
                this.remove(this.currentControl);
            }
            JComboBox<IncompatibleExtension.Fix> comboBox = new JComboBox<IncompatibleExtension.Fix>(fixes);
            if (selectedFix != null) {
                comboBox.setSelectedItem((Object)selectedFix);
            }
            comboBox.setPreferredSize(CONTROL_SIZE);
            this.add(comboBox, CONTROL_CONSTRAINTS);
            comboBox.addItemListener(e -> {
                if (e.getID() == 701 && e.getStateChange() == 1) {
                    this.extension.setFix((IncompatibleExtension.Fix)((Object)((Object)e.getItem())));
                }
            });
            this.currentControl = comboBox;
            this.revalidate();
            this.repaint();
        }

        static {
            CONTROL_SIZE = new Dimension(120, 24);
            UNKNOWN_ICON = SwingTools.createIcon((String)("48/" + I18N.getGUIMessage((String)"gui.dialog.incompatible_extensions.unknown_icon", (Object[])new Object[0])));
            INFO_ICON = SwingTools.createIcon((String)("16/" + I18N.getGUIMessage((String)"gui.dialog.incompatible_extensions.info_icon", (Object[])new Object[0])));
            WARNING_ICON = SwingTools.createIcon((String)("16/" + I18N.getGUIMessage((String)"gui.dialog.incompatible_extensions.warning_icon", (Object[])new Object[0])));
            ICON_CONSTRAINTS = new GridBagConstraints();
            ExtensionPanel.ICON_CONSTRAINTS.insets = new Insets(4, 12, 4, 12);
            ExtensionPanel.ICON_CONSTRAINTS.gridx = 0;
            ExtensionPanel.ICON_CONSTRAINTS.weightx = 0.0;
            LABEL_CONSTRAINTS = new GridBagConstraints();
            ExtensionPanel.LABEL_CONSTRAINTS.insets = ExtensionPanel.ICON_CONSTRAINTS.insets;
            ExtensionPanel.LABEL_CONSTRAINTS.anchor = 10;
            ExtensionPanel.LABEL_CONSTRAINTS.fill = 2;
            ExtensionPanel.LABEL_CONSTRAINTS.gridx = 1;
            ExtensionPanel.LABEL_CONSTRAINTS.weightx = 1.0;
            INFO_CONSTRAINTS = new GridBagConstraints();
            ExtensionPanel.INFO_CONSTRAINTS.insets = ExtensionPanel.ICON_CONSTRAINTS.insets;
            ExtensionPanel.INFO_CONSTRAINTS.anchor = 10;
            ExtensionPanel.INFO_CONSTRAINTS.fill = 2;
            ExtensionPanel.INFO_CONSTRAINTS.gridx = 2;
            ExtensionPanel.INFO_CONSTRAINTS.weightx = 0.0;
            CONTROL_CONSTRAINTS = new GridBagConstraints();
            ExtensionPanel.CONTROL_CONSTRAINTS.insets = ExtensionPanel.ICON_CONSTRAINTS.insets;
            ExtensionPanel.CONTROL_CONSTRAINTS.anchor = 10;
            ExtensionPanel.CONTROL_CONSTRAINTS.gridx = 3;
            ExtensionPanel.CONTROL_CONSTRAINTS.weightx = 0.0;
        }
    }
}

