/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.filter;

import com.rapidminer.gui.look.fc.Tools;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class RMSImageFilter
extends RGBImageFilter {
    private static final int ALPHA_MASK = -16777216;

    @Override
    public int filterRGB(int x, int y, int rgb) {
        double squareSum = 0.0;
        for (int binPos = 0; binPos <= 16; binPos += 8) {
            squareSum += Math.pow(rgb >> binPos & 0xFF, 2.0);
        }
        int rms = (int)Math.sqrt(squareSum / 3.0);
        return rgb & 0xFF000000 | rms << 16 | rms << 8 | rms;
    }

    public static ImageIcon convertIcon(Icon icon) {
        Image image = Tools.asImage((Icon)icon);
        return image == null ? null : new ImageIcon(RMSImageFilter.convertImage(image));
    }

    public static Image convertImage(Image image) {
        if (image == null) {
            return null;
        }
        RMSImageFilter filter = new RMSImageFilter();
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }
}

