/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.globalsearch;

import com.rapidminer.deployment.update.client.UpdateDialog;
import com.rapidminer.gui.search.GlobalSearchGUIUtilities;
import com.rapidminer.gui.search.GlobalSearchableGUIProvider;
import com.rapidminer.gui.tools.Ionicon;
import com.rapidminer.gui.tools.MultiSwingWorker;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.settings.Telemetry;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RMUrlHandler;
import com.rapidminer.tools.WebServiceTools;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.dnd.DragGestureListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.lucene.document.Document;

public class MarketplaceGlobalSearchGUIProvider
implements GlobalSearchableGUIProvider {
    private static final String ICON_REST_PATH = "/producticon/";
    private static final float FONT_SIZE_NAME = 14.0f;
    private static final float FONT_SIZE_VENDOR = 9.0f;
    private static final ImageIcon EXTENSION_FALLBACK_ICON = SwingTools.createIcon((String)"16/piece2.png");
    private static final ImageIcon LOADING_ICON = SwingTools.createIcon((String)"16/loading.gif");
    private static final Border ICON_EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 15);
    private static final Color VENDOR_COLOR = new Color(62, 62, 62);
    private static final String TOOLTIP_TEMPLATE = "<html><div style=\"width:500px;font-size: 10px;font-family:'Open Sans'\">%s</div></html>";
    private static final Map<String, Icon> ICON_CACHE = new ConcurrentHashMap<String, Icon>();
    private static final int DOWNSCALED_ICON_WIDTH = 16;
    private static final int DOWNSCALED_ICON_HEIGHT = 16;
    private static final Color BLACKLISTED_PLUGIN_NAME_COLOR = new Color(150, 150, 150);
    private static final Icon BLACKLISTED_ICON = SwingTools.createIcon((String)("16/" + I18N.getGUIMessage((String)"gui.icon.plugin_blacklisted.icon", (Object[])new Object[0])), (boolean)true);
    private static final Color BLACKLISTED_VENDOR_COLOR = new Color(128, 128, 128).brighter();

    public JComponent getGUIListComponentForDocument(Document document, String[] bestFragments) {
        boolean blacklisted;
        if (Telemetry.MARKETPLACE.isDenied()) {
            return null;
        }
        String extensionId = document.get("id");
        String name = document.get("name");
        String vendor = document.get("vendor");
        final String vendorId = document.get("vendorId");
        String description = document.get("description");
        name = GlobalSearchGUIUtilities.INSTANCE.createHTMLHighlightFromString(name, bestFragments);
        final JPanel mainListPanel = new JPanel(new BorderLayout());
        mainListPanel.setOpaque(false);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setOpaque(false);
        JPanel vendorPanel = new JPanel(new BorderLayout());
        vendorPanel.setOpaque(false);
        JLabel nameListLabel = new JLabel();
        nameListLabel.setFont(nameListLabel.getFont().deriveFont(1).deriveFont(14.0f));
        JLabel vendorLabel = new JLabel();
        vendorLabel.setFont(vendorLabel.getFont().deriveFont(9.0f));
        vendorLabel.setForeground(VENDOR_COLOR);
        final JLabel supportedLabel = new JLabel();
        supportedLabel.setFont(vendorLabel.getFont());
        supportedLabel.setHorizontalAlignment(2);
        JLabel iconListLabel = new JLabel();
        iconListLabel.setBorder(ICON_EMPTY_BORDER);
        vendorPanel.add((Component)vendorLabel, "West");
        descriptionPanel.add((Component)nameListLabel, "Center");
        descriptionPanel.add((Component)vendorPanel, "South");
        mainListPanel.add((Component)iconListLabel, "West");
        mainListPanel.add((Component)descriptionPanel, "Center");
        mainListPanel.setToolTipText(this.createTooltip(description));
        nameListLabel.setText(name);
        Icon icon = ICON_CACHE.get(extensionId);
        boolean needIconLoading = icon == null;
        icon = icon != null ? icon : LOADING_ICON;
        iconListLabel.setIcon(icon);
        vendorLabel.setText(this.createVendorString(vendor));
        boolean bl = blacklisted = !Plugin.isExtensionWhitelisted((String)extensionId);
        if (blacklisted) {
            nameListLabel.setText(document.get("name"));
            nameListLabel.setForeground(BLACKLISTED_PLUGIN_NAME_COLOR);
            vendorLabel.setForeground(BLACKLISTED_VENDOR_COLOR);
            needIconLoading = false;
            iconListLabel.setIcon(BLACKLISTED_ICON);
            mainListPanel.setToolTipText(I18N.getGUILabel((String)"plugin_blacklisted.tip", (Object[])new Object[]{extensionId}));
        }
        if ("1002".equals(vendorId)) {
            supportedLabel.setText(this.createSupportedString(vendorId, false, blacklisted));
            supportedLabel.setToolTipText(I18N.getGUILabel((String)"global_search.marketplace.vendor_supported.tip", (Object[])new Object[0]));
            supportedLabel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    RMUrlHandler.openInBrowser((String)I18N.getGUILabel((String)"global_search.marketplace.vendor_supported.url", (Object[])new Object[0]));
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    mainListPanel.dispatchEvent(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    supportedLabel.setText(MarketplaceGlobalSearchGUIProvider.this.createSupportedString(vendorId, true, blacklisted));
                    mainListPanel.dispatchEvent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    supportedLabel.setText(MarketplaceGlobalSearchGUIProvider.this.createSupportedString(vendorId, false, blacklisted));
                    mainListPanel.dispatchEvent(e);
                }
            });
            vendorPanel.add((Component)supportedLabel, "Center");
        }
        if (needIconLoading) {
            this.loadIconAsync(document, iconListLabel);
        }
        return mainListPanel;
    }

    public String getI18nNameForSearchable() {
        return I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.component.global_search.marketplace.category.title", (Object[])new Object[0]);
    }

    public void searchResultTriggered(Document document, GlobalSearchableGUIProvider.Veto veto) {
        UpdateDialog.showUpdateDialogForSpecificExtension(document.get("id"));
    }

    public void searchResultBrowsed(Document document) {
    }

    public boolean isDragAndDropSupported(Document document) {
        return false;
    }

    public DragGestureListener getDragAndDropSupport(Document document) {
        return null;
    }

    private void loadIconAsync(final Document document, final JLabel iconListLabel) {
        MultiSwingWorker<ImageIcon, Void> worker = new MultiSwingWorker<ImageIcon, Void>(){

            protected ImageIcon doInBackground() throws Exception {
                String extensionId = document.get("id");
                String urlString = MarketplaceGlobalSearchGUIProvider.this.createMarketplaceIconUrl(extensionId);
                URL url = new URL(urlString);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                WebServiceTools.setURLConnectionDefaults((URLConnection)conn);
                conn.setRequestMethod("GET");
                conn.setUseCaches(false);
                conn.setAllowUserInteraction(false);
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    BufferedImage iconImage = ImageIO.read(conn.getInputStream());
                    BufferedImage scaledImage = new BufferedImage(16, 16, 2);
                    Graphics2D g2 = scaledImage.createGraphics();
                    g2.drawImage(iconImage.getScaledInstance(16, 16, 4), 0, 0, 16, 16, null);
                    g2.dispose();
                    return new ImageIcon(scaledImage);
                }
                LogService.getRoot().log(Level.WARNING, "com.rapidminer.gui.globalsearch.MarketplaceGlobalSearchGUIProvider.error.lazy_loading_code", new Object[]{extensionId, responseCode});
                return null;
            }

            protected void done() {
                try {
                    ImageIcon icon = (ImageIcon)this.get();
                    if (icon != null) {
                        ICON_CACHE.put(document.get("id"), icon);
                        iconListLabel.setIcon(icon);
                    } else {
                        iconListLabel.setIcon(EXTENSION_FALLBACK_ICON);
                    }
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "com.rapidminer.gui.globalsearch.MarketplaceGlobalSearchGUIProvider.error.lazy_loading", e);
                    iconListLabel.setIcon(EXTENSION_FALLBACK_ICON);
                }
            }
        };
        worker.start();
    }

    private String createMarketplaceIconUrl(String extensionId) {
        return "https://marketplace.rapidminer.com/UpdateServer/producticon/" + extensionId;
    }

    private String createTooltip(String description) {
        return String.format(TOOLTIP_TEMPLATE, description);
    }

    private String createVendorString(String vendor) {
        return "<html>" + I18N.getGUILabel((String)"global_search.marketplace.vendor.label", (Object[])new Object[0]) + ": " + vendor + "</html>";
    }

    private String createSupportedString(String vendorId, boolean highlighted, boolean blacklisted) {
        StringBuilder sb = new StringBuilder();
        if ("1002".equals(vendorId)) {
            sb.append("<html>");
            sb.append(' ');
            sb.append("&emsp;");
            sb.append("<span style=\"font-style:normal;color:#4D91E3;");
            if (highlighted) {
                sb.append("text-decoration:underline;color:#FF6600;");
            }
            if (blacklisted) {
                Color c = BLACKLISTED_VENDOR_COLOR;
                sb.append(String.format("color: rgb(%d, %d, %d);", c.getRed(), c.getGreen(), c.getBlue()));
            }
            sb.append("\">");
            sb.append(Ionicon.CHECKMARK_CIRCLED.getHtml());
            sb.append(' ');
            sb.append(I18N.getGUILabel((String)"global_search.marketplace.vendor_supported.label", (Object[])new Object[0]));
            sb.append("</span>");
            sb.append("</html>");
        }
        return sb.toString();
    }
}

