/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.local.search;

import com.rapidminer.deployment.update.client.UpdateDialog;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.LinkLocalButton;
import com.rapidminer.search.ExtensionItem;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarketplacePanelResults
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DOTS = "...";
    private static final String QUOTE = "\"";
    private static final int MAX_LENGTH = 32;
    private static final Icon GLOBE_ICON = SwingTools.createIcon((String)I18N.getGUILabel((String)"search.globe.icon", (Object[])new Object[0]));
    private GridBagConstraints gbc = new GridBagConstraints();
    private LinkLocalButton openMarketplace;

    public MarketplacePanelResults() {
        super(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(2, 0, 2, 7);
        this.add((Component)new JLabel(GLOBE_ICON), this.gbc);
        GridBagConstraints gbcL = this.gbc;
        ++gbcL.gridx;
        gbcL.weightx = 1.0;
        gbcL.fill = 2;
        this.add((Component)new JLabel(), gbcL);
    }

    public void updateResults(List<ExtensionItem> extensions, String keyword) {
        if (this.openMarketplace != null) {
            this.remove((Component)this.openMarketplace);
        }
        if (extensions.isEmpty()) {
            this.openMarketplace = new LinkLocalButton((Action)this.createAction("search.zero_results", keyword, new String[0]));
        } else if (extensions.size() == 1) {
            this.openMarketplace = new LinkLocalButton((Action)this.createAction("search.one_result", keyword, this.trimName(extensions.get(0).getName(), 32)));
        } else if (extensions.size() == 2) {
            this.openMarketplace = new LinkLocalButton((Action)this.createAction("search.two_results", keyword, this.trimName(extensions.get(0).getName(), 32), this.trimName(extensions.get(1).getName(), 32)));
        } else if (extensions.size() == 3) {
            this.openMarketplace = new LinkLocalButton((Action)this.createAction("search.three_results", keyword, this.trimName(extensions.get(0).getName(), 32), this.trimName(extensions.get(1).getName(), 32)));
        } else if (extensions.size() > 3) {
            this.openMarketplace = new LinkLocalButton((Action)this.createAction("search.more_results", keyword, this.trimName(extensions.get(0).getName(), 32), this.trimName(extensions.get(1).getName(), 32), Integer.toString(extensions.size() - 2)));
        }
        this.add((Component)this.openMarketplace, this.gbc);
    }

    private String trimName(String name, int size) {
        Object newName = name.length() < size ? name : name.substring(0, size - DOTS.length()).trim() + DOTS;
        return QUOTE + (String)newName + QUOTE;
    }

    private ResourceAction createAction(String id, final String keyword, String ... arguments) {
        ResourceAction action = new ResourceAction(id, arguments){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                UpdateDialog.showUpdateDialog(false, keyword, new String[0]);
                ActionStatisticsCollector.INSTANCE.log("marketplace", "operator_search", keyword);
            }
        };
        return action;
    }
}

