/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.local.search;

import com.rapidminer.gui.local.search.MarketplacePanelResults;
import com.rapidminer.gui.local.search.MarketplacePanelSearchLoading;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.search.ExtensionItem;
import com.rapidminer.search.ExtensionService;
import com.rapidminer.settings.Telemetry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarketplacePanelSearch
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComponent parent;
    private MarketplacePanelSearchLoading loadingPanel;
    private MarketplacePanelResults resultsPanel;
    private GridBagConstraints gbc;

    public MarketplacePanelSearch() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Colors.TAB_BORDER));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.loadingPanel = new MarketplacePanelSearchLoading();
        this.resultsPanel = new MarketplacePanelResults();
        this.add((Component)this.loadingPanel, this.gbc);
        GridBagConstraints gbcL = this.gbc;
        ++gbcL.gridx;
        gbcL.weightx = 1.0;
        gbcL.fill = 2;
        this.add((Component)new JLabel(), gbcL);
    }

    public void setParent(JComponent parent) {
        this.parent = parent;
    }

    public void search(final String keyword) {
        new ProgressThread("marketplace_localSearch"){

            public void run() {
                SwingTools.invokeLater((Runnable)new Runnable(){
                    List<ExtensionItem> extensions;
                    {
                        this.extensions = ExtensionService.INSTANCE.find(keyword);
                    }

                    @Override
                    public void run() {
                        MarketplacePanelSearch.this.resultsPanel.updateResults(this.extensions, keyword);
                        MarketplacePanelSearch.this.remove(MarketplacePanelSearch.this.loadingPanel);
                        MarketplacePanelSearch.this.add((Component)MarketplacePanelSearch.this.resultsPanel, MarketplacePanelSearch.this.gbc);
                        MarketplacePanelSearch.this.revalidate();
                        MarketplacePanelSearch.this.repaint();
                        MarketplacePanelSearch.this.updateParent();
                    }
                });
            }
        }.start();
    }

    public void reset() {
        this.remove(this.resultsPanel);
        this.add((Component)this.loadingPanel, this.gbc);
        this.revalidate();
        this.repaint();
        this.updateParent();
    }

    public void updateParent() {
        if (this.parent != null) {
            this.parent.revalidate();
            this.parent.repaint();
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !Telemetry.MARKETPLACE.isDenied();
    }
}

