/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.launcher;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.altair.license.StudioConstraintsManager;
import com.rapidminer.core.license.DatabaseConstraintViolationException;
import com.rapidminer.core.license.LicenseViolationException;
import com.rapidminer.gui.ProcessThread;
import com.rapidminer.gui.license.altair.AltairLicenseDetection;
import com.rapidminer.launcher.CustomCommandLineLauncher;
import com.rapidminer.license.LicenseManagerRegistry;
import com.rapidminer.license.verification.JarVerifier;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.security.PluginSandboxPolicy;
import com.rapidminer.security.PluginSecurityManager;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.ShutdownHooks;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.net.UserProvidedTLSCertificateLoader;
import com.rapidminer.tools.plugin.Plugin;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Policy;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.stream.Stream;

public class CommandLineLauncher
extends RapidMiner
implements BreakpointListener {
    private static final String LICENSE = "Altair AI Studio version " + RapidMiner.getLongDisplayVersion() + ", Copyright (C) 2001-2024 Altair Engineering Inc." + Tools.getLineSeparator() + "See End User License Agreement information in the file named EULA.";
    private static final String CUSTOM_LOADER_CLASS_SWITCH = "-C";
    private String repositoryLocation = null;
    private boolean readFromFile = false;
    private String[] allNormalArgs = new String[0];
    private String customCommandLineLauncher = null;
    private final List<Pair<String, String>> macros = new ArrayList<Pair<String, String>>();

    public void breakpointReached(Process process, Operator operator, IOContainer container, int location) {
        System.out.println("Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":" + Tools.getLineSeparator() + container);
        System.out.println("Breakpoint reached " + (location == 0 ? "before " : "after ") + operator.getName() + ", press enter...");
        new WaitForKeyThread(process).start();
    }

    public void resume() {
    }

    private void parseArguments(String[] argv) {
        this.repositoryLocation = null;
        this.allNormalArgs = (String[])Stream.of(argv).filter(a -> !a.startsWith(CUSTOM_LOADER_CLASS_SWITCH)).toArray(String[]::new);
        for (String element : argv) {
            if (element == null) continue;
            if (element.startsWith(CUSTOM_LOADER_CLASS_SWITCH)) {
                this.customCommandLineLauncher = element.substring(CUSTOM_LOADER_CLASS_SWITCH.length());
                continue;
            }
            if ("-f".equals(element)) {
                this.readFromFile = true;
                continue;
            }
            if (element.startsWith("-M")) {
                String elementSubstring = element.substring(2);
                String[] split = elementSubstring.split("=", 2);
                String value = split.length == 2 ? split[1] : "";
                this.macros.add((Pair<String, String>)new Pair((Object)split[0], (Object)value));
                continue;
            }
            if (this.repositoryLocation != null) continue;
            this.repositoryLocation = element;
        }
        if (this.customCommandLineLauncher == null && this.repositoryLocation == null) {
            this.printUsage();
        }
    }

    private void printUsage() {
        System.err.println("Usage: " + CommandLineLauncher.class.getName() + " [-f] PROCESS [-Mname=value]\n  PROCESS       a repository location containing a process\n  -f            interpret PROCESS as a file rather than a repository location (deprecated)\n  -Mname=value  sets the macro 'name' with the value 'value'");
        System.exit(1);
    }

    private void run() {
        CommandLineLauncher.initRapidMiner();
        Class<? extends CustomCommandLineLauncher> c = this.findCustomLauncher();
        if (c != null) {
            try {
                CustomCommandLineLauncher customLauncher = c.newInstance();
                customLauncher.run(this.allNormalArgs);
            }
            catch (IllegalAccessException | InstantiationException e) {
                System.err.println("Failed to instantiate command line launcher: " + e.getMessage());
            }
        } else {
            Process process = null;
            try {
                if (this.readFromFile) {
                    process = RapidMiner.readProcessFile((File)new File(this.repositoryLocation));
                } else {
                    RepositoryProcessLocation loc = new RepositoryProcessLocation(new RepositoryLocationBuilder().withExpectedDataEntryType(ProcessEntry.class).buildFromAbsoluteLocation(this.repositoryLocation));
                    process = loc.load(null);
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapidminer.RapidMinerCommandLine.reading_process_setup_error", (Object[])new Object[]{this.repositoryLocation, e.getMessage()}), e);
                RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.ERROR);
            }
            if (process != null) {
                this.runProcessAndQuit(process);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcessAndQuit(Process process) {
        try {
            for (Pair<String, String> macro : this.macros) {
                process.getContext().addMacro(macro);
            }
            process.addBreakpointListener((BreakpointListener)this);
            IOContainer results = process.run();
            process.getRootOperator().sendEmail(results, null);
            LogService.getRoot().log(Level.INFO, "com.rapidminer.RapidMinerCommandLine.process_finished");
            RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.NORMAL);
        }
        catch (OutOfMemoryError e) {
            LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.out_of_memory");
            ActionStatisticsCollector.getInstance().log("error", "out_of_memory", String.valueOf(SystemInfoUtilities.getMaxHeapMemorySize()));
            process.getLogger().log(Level.SEVERE, "Here: " + process.getRootOperator().createMarkedProcessTree(10, "==>", process.getCurrentOperator()));
            try {
                process.getRootOperator().sendEmail(null, (Throwable)e);
            }
            catch (UndefinedParameterError macro) {
                // empty catch block
            }
        }
        catch (DatabaseConstraintViolationException ex) {
            if (ex.getOperatorName() != null) {
                LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.database_constraint_violation_exception_in_operator", new Object[]{ex.getDatabaseURL(), ex.getOperatorName()});
            } else {
                LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.database_constraint_violation_exception", new Object[]{ex.getDatabaseURL()});
            }
        }
        catch (LicenseViolationException e) {
            LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.operator_constraint_violation_exception", new Object[]{e.getOperatorName()});
        }
        catch (Throwable e) {
            String debugProperty = ParameterService.getParameterValue((String)"rapidminer.general.debugmode");
            boolean debugMode = Tools.booleanValue((String)debugProperty, (boolean)false);
            ProcessThread.logProcessError((Process)process, (Throwable)e, (boolean)debugMode);
            process.getLogger().log(Level.SEVERE, "Here: " + process.getRootOperator().createMarkedProcessTree(10, "==>", process.getCurrentOperator()));
            try {
                process.getRootOperator().sendEmail(null, e);
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
        finally {
            ActionStatisticsCollector.getInstance().log(process.getCurrentOperator(), "FAILURE");
            ActionStatisticsCollector.getInstance().log(process.getCurrentOperator(), "RUNTIME_EXCEPTION");
            LogService.getRoot().severe("Process not successful");
            RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.ERROR);
        }
    }

    private static void initRapidMiner() {
        PlatformUtilities.initialize((PlatformUtilities.ExecutionMode)PlatformUtilities.ExecutionMode.COMMAND_LINE);
        UserProvidedTLSCertificateLoader.INSTANCE.init(true);
        RapidMiner.init();
        ShutdownHooks.addShutdownHook(() -> UsageStatistics.getInstance().save());
    }

    private Class<? extends CustomCommandLineLauncher> findCustomLauncher() {
        if (this.customCommandLineLauncher != null) {
            String launcherClass;
            ClassLoader classLoader;
            String[] str = this.customCommandLineLauncher.split(":");
            if (str.length > 1) {
                Plugin plugin = Plugin.getPluginByExtensionId((String)str[0]);
                if (plugin == null) {
                    System.err.println("Cannot find plugin with id " + str[0]);
                    System.exit(1);
                }
                classLoader = plugin.getClassLoader();
                launcherClass = str[1];
            } else {
                classLoader = CommandLineLauncher.class.getClassLoader();
                launcherClass = str[0];
            }
            try {
                Class<?> c = Class.forName(launcherClass, true, classLoader);
                if (CustomCommandLineLauncher.class.isAssignableFrom(c)) {
                    this.verifyClass(c);
                    return c.asSubclass(CustomCommandLineLauncher.class);
                }
                System.err.println("Invalid command line launcher implementation specified: " + c.getSimpleName());
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("Invalid command line launcher class specified: " + t.getMessage());
                System.exit(1);
            }
        }
        return null;
    }

    private void verifyClass(Class<?> c) {
        try {
            JarVerifier.verify((Class[])new Class[]{c});
        }
        catch (GeneralSecurityException e) {
            System.err.println("Failed to verify Altair AI Studio installation: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        Settings.setSetting((String)"rapidminer.logging.resource-file-jar-path", (String)"com.rapidminer.resources.i18n.LogMessages");
        Policy.setPolicy((Policy)new PluginSandboxPolicy());
        System.setSecurityManager((SecurityManager)new PluginSecurityManager());
        CommandLineLauncher.setExecutionMode((RapidMiner.ExecutionMode)RapidMiner.ExecutionMode.COMMAND_LINE);
        DirectoryService.checkForMigrations((window, e) -> {
            if (e != null) {
                e.printStackTrace();
            }
            System.err.println("The directory migration process failed. In most cases, this is due to another program accessing and blocking the files that need to be migrated. The current instance will shut down. Please make sure that no other instance of AI Studio (formerly RapidMiner Studio) is running and that files in the working directory are not used by any other program. Then restart AI Studio.");
            RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.NORMAL);
        });
        AltairLicenseDetection.detectLicenseMangerHeadless();
        try {
            JarVerifier.verify((Class[])new Class[]{StudioConstraintsManager.getInstance().getClass(), LicenseManagerRegistry.INSTANCE.get().getClass(), RapidMiner.class, CommandLineLauncher.class});
        }
        catch (GeneralSecurityException e2) {
            System.err.println("Failed to verify Altair AI Studio installation: " + e2.getMessage());
            System.exit(1);
        }
        System.out.println(LICENSE);
        CommandLineLauncher main = new CommandLineLauncher();
        main.parseArguments(argv);
        main.run();
    }

    private static class WaitForKeyThread
    extends Thread {
        private final Process process;

        public WaitForKeyThread(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                System.in.read();
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapidminer.RapidMinerCommandLine.waiting_for_user_input_error", (Object[])new Object[]{e.getMessage()}), e);
            }
            this.process.resume();
        }
    }
}

