/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.launcher;

import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.container.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import sun.misc.Unsafe;

public final class JVMOptionBuilder {
    private static final String LAUNCHER_LOG = "launcher.log";
    private static final String ARGUMENTS_PROTOCOL_HANDLER = " -Xmx128m -XX:InitiatingHeapOccupancyPercent=55 -Djava.awt.headless=true -Djava.net.preferIPv4Stack=true";
    private static final long MINIMUM_RM_MEMORY = 384L;
    private static final long MAX_32BIT_MEMORY = 1000L;
    private static final long MEMORY_TRESHOLD = 4069L;
    private static final double MEMORY_PORTION = 0.75;
    private static final String WINDOWS_CLASSPATH_SEPARATOR = ";";
    private static final String UNIX_CLASSPATH_SEPARATOR = ":";
    private static final Logger LOGGER = Logger.getLogger(JVMOptionBuilder.class.getSimpleName());
    private static boolean verbose = false;
    private static final String[] OPENED_PACKAGES = new String[]{"java.desktop/sun.awt.shell=ALL-UNNAMED", "java.desktop/sun.swing=ALL-UNNAMED", "java.desktop/javax.swing=ALL-UNNAMED", "java.desktop/javax.swing.text.html=ALL-UNNAMED", "java.base/java.util=ALL-UNNAMED", "java.base/java.io=ALL-UNNAMED", "java.base/java.net=ALL-UNNAMED", "java.base/java.lang=ALL-UNNAMED", "java.sql/java.sql=ALL-UNNAMED", "java.base/java.lang.reflect=ALL-UNNAMED"};

    private JVMOptionBuilder() {
        throw new AssertionError();
    }

    private static void addSystemSpecificSettings(StringBuilder builder) {
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.OSX) {
            builder.append(" --add-opens java.desktop/com.apple.eawt=ALL-UNNAMED");
            builder.append(" --add-opens java.desktop/sun.lwawt.macosx=ALL-UNNAMED");
            builder.append(" -Xdock:icon=");
            String dockIconPath = PlatformUtilities.getRapidMinerHome() + "/../rapidminer_frame_icon.icns";
            builder.append(JVMOptionBuilder.escapeBlanks(dockIconPath));
            builder.append(" -Xdock:name=");
            builder.append(JVMOptionBuilder.escapeBlanks("AI Studio"));
            builder.append(" -Dcom.apple.mrj.application.apple.menu.about.name=");
            builder.append(JVMOptionBuilder.escapeBlanks("AI Studio"));
            builder.append(" -Dapple.laf.useScreenMenuBar=true");
            builder.append(" -Dcom.apple.mrj.application.growbox.intrudes=true");
            builder.append(" -Dapple.awt.antialiasing=true");
            builder.append(" -Dcom.apple.mrj.application.live-resize=true");
            builder.append(" -Dsun.java2d.opengl=true");
        } else if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            builder.append(" -Djava.net.preferIPv4Stack=true");
            builder.append(" -Dsun.java2d.dpiaware=false");
        }
    }

    private static String escapeBlanks(String path) {
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.OSX || SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.SOLARIS || SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.UNIX) {
            return path.replace(" ", "\\ ");
        }
        return "\"" + path + "\"";
    }

    private static void addMemorySettings(StringBuilder builder, long userMaxMemorySetting) {
        JVMOptionBuilder.log("Calculating JVM memory settings...");
        long totalPhysicalMemorySize = 384L;
        try {
            totalPhysicalMemorySize = SystemInfoUtilities.getTotalPhysicalMemorySize();
            JVMOptionBuilder.log("Total physical memory detected: " + totalPhysicalMemorySize);
        }
        catch (IOException e1) {
            JVMOptionBuilder.log("Could not detect total physical memory.. assuming at least 384mb");
        }
        long memoryLimit = -1L;
        memoryLimit = (double)totalPhysicalMemorySize * 0.25 > 4069.0 ? totalPhysicalMemorySize - 4069L : (long)((double)totalPhysicalMemorySize * 0.75);
        JVMOptionBuilder.log("Calculating maximum usable memory for AI Studio... ");
        JVMOptionBuilder.log("Set maximum usable memory to " + memoryLimit + "mb");
        if (userMaxMemorySetting >= 384L) {
            if (userMaxMemorySetting <= totalPhysicalMemorySize) {
                JVMOptionBuilder.log("Max allowed memory has been set in the AI Studio preferences to " + userMaxMemorySetting + "mb. Using it instead of " + memoryLimit + "mb of memory.");
                memoryLimit = userMaxMemorySetting;
            } else {
                JVMOptionBuilder.log("Max allowed memory has been set to more than the total memory " + totalPhysicalMemorySize + "mb. Ignoring it.");
            }
        } else {
            JVMOptionBuilder.log("Max allowed memory has been set to less than 384mb. Ignoring because AI Studio must use at least 384mb.");
        }
        if (memoryLimit < 384L) {
            memoryLimit = 384L;
            JVMOptionBuilder.log("Maximum usable memory is below minimum memory for AI Studio! Set maximum usable memory to " + memoryLimit);
        } else if (SystemInfoUtilities.getJVMArchitecture() == SystemInfoUtilities.JVMArch.THIRTY_TWO && memoryLimit > 1000L) {
            memoryLimit = 1000L;
            JVMOptionBuilder.log("Maximum usable memory is above maximum memory for a 32bit JVM. Set maximum to " + memoryLimit);
        }
        JVMOptionBuilder.log("Using up to " + memoryLimit + "mb of memory.");
        builder.append(" -Xms");
        builder.append(384L);
        builder.append("m");
        builder.append(" -Xmx");
        builder.append(memoryLimit);
        builder.append("m");
    }

    private static void addGarbageCollection(StringBuilder builder, boolean useCompactGC) {
        if (useCompactGC) {
            builder.append(" -XX:+UseShenandoahGC");
            builder.append(" -XX:ShenandoahGCHeuristics=compact");
        } else {
            builder.append(" -XX:+UseG1GC");
            builder.append(" -XX:G1HeapRegionSize=32m");
        }
        int cores = SystemInfoUtilities.getNumberOfProcessors();
        if (cores <= 16) {
            builder.append(" -XX:ParallelGCThreads=");
            builder.append(Math.max(2, cores / 2));
        }
        builder.append(" -XX:InitiatingHeapOccupancyPercent=55");
    }

    private static void addClassPath(StringBuilder builder) {
        builder.append("-cp ");
        builder.append("\"");
        String classPathSeparator = WINDOWS_CLASSPATH_SEPARATOR;
        if (SystemInfoUtilities.getOperatingSystem() != SystemInfoUtilities.OperatingSystem.WINDOWS) {
            classPathSeparator = UNIX_CLASSPATH_SEPARATOR;
        }
        JVMOptionBuilder.log("Classpath separator: " + classPathSeparator);
        File libFolder = new File(PlatformUtilities.getRapidMinerHome(), "lib");
        JVMOptionBuilder.addLibsInFolder(libFolder, builder, classPathSeparator);
        File freehepFolder = new File(libFolder, "freehep");
        JVMOptionBuilder.addLibsInFolder(freehepFolder, builder, classPathSeparator);
        builder.append("\"");
    }

    private static void addLibsInFolder(File folder, StringBuilder builder, String classPathSeperator) {
        if (!folder.isDirectory()) {
            return;
        }
        for (File lib : folder.listFiles()) {
            if (!lib.isFile() || !lib.getName().contains(".jar")) continue;
            JVMOptionBuilder.log("Adding lib to classpath: " + lib);
            builder.append(lib.getAbsolutePath());
            builder.append(classPathSeperator);
        }
    }

    public static String getJVMOptions(boolean addClasspath, Pair<Long, Boolean> userMemorySettings) {
        PlatformUtilities.ensureRapidMinerHomeSet((boolean)false);
        StringBuilder builder = new StringBuilder();
        if (addClasspath) {
            JVMOptionBuilder.addClassPath(builder);
        }
        JVMOptionBuilder.addGarbageCollection(builder, (Boolean)userMemorySettings.getSecond());
        JVMOptionBuilder.addMemorySettings(builder, (Long)userMemorySettings.getFirst());
        JVMOptionBuilder.addSystemSpecificSettings(builder);
        builder.append(" -Djava.locale.providers=COMPAT");
        builder.append(" -Djava.net.useSystemProxies=true");
        builder.append(" -Drapidminer.general.timezone=SYSTEM");
        JVMOptionBuilder.addModules(builder);
        return builder.toString();
    }

    private static void addModules(StringBuilder builder) {
        for (String module : OPENED_PACKAGES) {
            builder.append(" --add-opens ");
            builder.append(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            JVMOptionBuilder.disableIllegalAccessWarning();
            LogService.getRoot().setLevel(Level.OFF);
            for (Handler handler : LOGGER.getHandlers()) {
                LOGGER.removeHandler(handler);
            }
            PlatformUtilities.initialize((PlatformUtilities.ExecutionMode)PlatformUtilities.ExecutionMode.COMMAND_LINE);
            try {
                FileHandler logFileHandler = new FileHandler(DirectoryService.resolveWorkingDir((String)LAUNCHER_LOG, (String[])new String[0]).toFile().getAbsolutePath(), false);
                logFileHandler.setLevel(Level.ALL);
                logFileHandler.setFormatter(new SimpleFormatter());
                LOGGER.addHandler(logFileHandler);
                LOGGER.setUseParentHandlers(false);
                LOGGER.setLevel(Level.ALL);
            }
            catch (IOException logFileHandler) {
                // empty catch block
            }
            try {
                List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
                if (jvmArgs != null) {
                    StringBuilder sb = new StringBuilder();
                    for (String arg : jvmArgs) {
                        sb.append(arg);
                        sb.append(" ");
                    }
                    JVMOptionBuilder.log("JVM arguments were: " + sb.toString());
                }
            }
            catch (Throwable t) {
                JVMOptionBuilder.log("Failed to read JVM arguments!");
                t.printStackTrace();
            }
            try {
                Properties props = System.getProperties();
                if (props != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        sb.append(entry.getKey());
                        sb.append(":'").append(entry.getValue()).append("'");
                        sb.append(" ");
                    }
                    JVMOptionBuilder.log("System properties were: " + sb.toString());
                }
            }
            catch (Throwable t) {
                JVMOptionBuilder.log("Failed to read system properties!");
                t.printStackTrace();
            }
            if (args.length > 0 && args[0] != null && args[0].startsWith("rapidminer://")) {
                Socket other = JVMOptionBuilder.getOtherInstance();
                if (other != null) {
                    try {
                        other.close();
                    }
                    catch (IOException sb) {
                        // empty catch block
                    }
                    JVMOptionBuilder.log("Running instance found. Starting minimal version.");
                    System.out.print(ARGUMENTS_PROTOCOL_HANDLER);
                    System.out.flush();
                    System.exit(0);
                } else {
                    JVMOptionBuilder.log("No running instance found. Regular startup.");
                }
            }
            boolean addClasspath = false;
            for (String element : args) {
                if (element == null) continue;
                if ("--verbose-startup".equals(element)) {
                    verbose = true;
                }
                if (!"--addcp".equals(element)) continue;
                addClasspath = true;
            }
            if (verbose) {
                SystemInfoUtilities.logEnvironmentInfos();
            }
            if (SystemInfoUtilities.getJVMArchitecture() == SystemInfoUtilities.JVMArch.THIRTY_TWO && SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
                LOGGER.log(Level.WARNING, "32-bit Windows detected - This is not supported!");
            }
            String jvmOptions = JVMOptionBuilder.getJVMOptions(addClasspath, JVMOptionBuilder.readUserSettings());
            JVMOptionBuilder.log("Launch settings are: '" + jvmOptions + "'");
            System.out.print(jvmOptions);
            System.out.flush();
        }
        catch (Throwable t) {
            JVMOptionBuilder.log("Failed to run!");
            t.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void log(String toLog) {
        LOGGER.log(Level.INFO, toLog);
    }

    private static Pair<Long, Boolean> readUserSettings() {
        long maxValue = Long.MAX_VALUE;
        boolean useShenandoahCompact = false;
        Properties rmPreferences = new Properties();
        try (InputStream in = Files.newInputStream(DirectoryService.getStudioSettings(), new OpenOption[0]);){
            JVMOptionBuilder.log("Trying to read user setting for maximum amount of memory.");
            rmPreferences.load(in);
            String maxUserMemory = rmPreferences.getProperty("maxMemory");
            if (maxUserMemory != null && !maxUserMemory.isEmpty()) {
                maxValue = Long.parseLong(maxUserMemory);
                JVMOptionBuilder.log("User setting for maximum amount of memory: " + maxValue);
            } else {
                JVMOptionBuilder.log("No user setting for maximum amount of memory found.");
            }
            String userGCSetting = rmPreferences.getProperty("rapidminer.system.memory_management");
            if (userGCSetting != null && !userGCSetting.isEmpty()) {
                useShenandoahCompact = "memory optimized".equals(userGCSetting);
                JVMOptionBuilder.log("User setting for memory management: " + (useShenandoahCompact ? "memory optimized" : "runtime optimized"));
            } else {
                JVMOptionBuilder.log("No user setting for memory management found.");
            }
        }
        catch (Exception e) {
            JVMOptionBuilder.log("Failed to read RM preferences for user specified max memory and memory management: " + e.getMessage());
        }
        return new Pair((Object)maxValue, (Object)useShenandoahCompact);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Socket getOtherInstance() {
        int port;
        File socketFile = DirectoryService.resolveWorkingDir((String)"rapidminer.lock", (String[])new String[0]).toFile();
        if (!socketFile.exists()) {
            return null;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(socketFile), StandardCharsets.UTF_8));){
            String portStr = in.readLine();
            if (portStr == null) {
                JVMOptionBuilder.log("Faild to retrieve port from socket file '" + socketFile + "'. File seems to be empty.");
                Socket socket = null;
                return socket;
            }
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            JVMOptionBuilder.log("Failed to read socket file '" + socketFile + "': " + e.getMessage());
            return null;
        }
        JVMOptionBuilder.log("Checking for running instance on port " + port + ".");
        try {
            return new Socket(InetAddress.getLoopbackAddress(), port);
        }
        catch (IOException e) {
            JVMOptionBuilder.log("Found lock file but no other instance running. Assuming unclean shutdown of previous launch.");
            return null;
        }
    }

    private static void disableIllegalAccessWarning() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            Class<?> clazz = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = clazz.getDeclaredField("logger");
            unsafe.putObjectVolatile(clazz, unsafe.staticFieldOffset(logger), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

