/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.launcher;

import com.rapidminer.RapidMiner;
import com.rapidminer.altair.license.StudioConstraintsManager;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.ToolbarGUIStartupListener;
import com.rapidminer.gui.internal.GUIStartupListener;
import com.rapidminer.gui.license.LicenseGUIStartupListener;
import com.rapidminer.gui.license.altair.AltairLicenseDetection;
import com.rapidminer.gui.license.onboarding.OnboardingGUIStartupListener;
import com.rapidminer.launcher.GUILauncher;
import com.rapidminer.launcher.LauncherTools;
import com.rapidminer.license.LicenseManagerRegistry;
import com.rapidminer.license.verification.JarVerifier;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.ProxySettings;
import com.rapidminer.tools.net.UserProvidedTLSCertificateLoader;
import com.rapidminer.tools.update.internal.MarketplaceGUIStartupListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;

@SuppressFBWarnings
public final class OSXGUILauncher {
    private static final Logger LOGGER = Logger.getLogger(GUILauncher.class.getName());

    private OSXGUILauncher() {
        throw new AssertionError((Object)"Utility class must not be instantiated.");
    }

    public static void main(String[] args) throws Exception {
        Settings.setSetting((String)"rapidminer.logging.resource-file-jar-path", (String)"com.rapidminer.resources.i18n.LogMessages");
        PlatformUtilities.initialize((PlatformUtilities.ExecutionMode)PlatformUtilities.ExecutionMode.UI);
        RapidMiner.setExecutionMode((RapidMiner.ExecutionMode)RapidMiner.ExecutionMode.UI);
        if (RapidMiner.getExecutionMode().canAccessFilesystem()) {
            DirectoryService.setDefaultExecutionWorkingDirectorySetting();
            DirectoryService.checkForMigrations((window, e) -> {
                LauncherTools.showMigrationErrorMessage(window, e);
                RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.NORMAL);
            });
            Settings.setSetting((String)"rapidminer.logging.log-file", (String)DirectoryService.getLogAbsolutePathString());
        }
        UserProvidedTLSCertificateLoader.INSTANCE.init(true);
        ProxySettings.storeSystemSettings();
        AltairLicenseDetection.detectLicenseManger();
        try {
            JarVerifier.verify((Class[])new Class[]{StudioConstraintsManager.getInstance().getClass(), LicenseManagerRegistry.INSTANCE.get().getClass(), RapidMiner.class, OSXGUILauncher.class});
        }
        catch (GeneralSecurityException e2) {
            LOGGER.log(Level.SEVERE, "Failed to verify Altair AI Studio installation: " + e2.getMessage(), e2);
            System.exit(1);
        }
        RapidMinerGUI.registerStartupListener((GUIStartupListener)new MarketplaceGUIStartupListener());
        RapidMinerGUI.registerStartupListener((GUIStartupListener)new OnboardingGUIStartupListener());
        RapidMinerGUI.registerStartupListener((GUIStartupListener)new LicenseGUIStartupListener());
        RapidMinerGUI.registerStartupListener((GUIStartupListener)new ToolbarGUIStartupListener());
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        RapidMinerGUI.main((String[])args);
    }
}

