/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.launcher;

import com.rapidminer.launcher.LauncherTools;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.PlatformUtilities;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;

public class PreLaunchMigrationManager {
    private static PlatformUtilities.ExecutionMode execMode;

    public static void main(String[] args) {
        execMode = PlatformUtilities.ExecutionMode.COMMAND_LINE;
        for (String element : args) {
            if (element == null || !"--ui".equals(element)) continue;
            execMode = PlatformUtilities.ExecutionMode.UI;
            System.setProperty("altair.pre_launch_migration.configure_ui", "true");
        }
        PreLaunchMigrationManager.prepareLogging();
        PreLaunchMigrationManager.checkForDirectoryServiceMigration();
        PreLaunchMigrationManager.writeLogFileToWorkingDirectory(DirectoryService.resolveWorkingDir((String)"migration.log", (String[])new String[0]));
    }

    private static void checkForDirectoryServiceMigration() {
        PreLaunchMigrationManager.log(Level.INFO, "Will check for necessary directory migration processes. If there are any, the migration might take some time, please be patient...");
        PlatformUtilities.initialize((PlatformUtilities.ExecutionMode)execMode);
        DirectoryService.checkForMigrations((window, e) -> {
            if (execMode == PlatformUtilities.ExecutionMode.UI) {
                LauncherTools.showMigrationErrorMessage(window, e);
            } else {
                PreLaunchMigrationManager.log(Level.SEVERE, "The directory migration process failed. In most cases, this is due to another program accessing and blocking the files that need to be migrated. The current instance will shut down. Please make sure that no other instance of AI Studio (formerly RapidMiner Studio) is running and that files in the working directory are not used by any other program. Then restart AI Studio.");
            }
            PreLaunchMigrationManager.writeLogFileToWorkingDirectory(DirectoryService.getFallbackDir().resolve("migration.log"));
            System.exit(1);
        });
        PreLaunchMigrationManager.log(Level.INFO, "Migration check (and a potential migration) is done.");
    }

    private static void prepareLogging() {
        Settings.setSetting((String)"rapidminer.logging.resource-file-jar-path", (String)"com.rapidminer.resources.i18n.LogMessages");
        Path tmpLog = null;
        try {
            tmpLog = Files.createTempFile("migration", "log", new FileAttribute[0]);
        }
        catch (IOException e) {
            PreLaunchMigrationManager.log(Level.SEVERE, "Can't create a log file for migration, won't write to a file.");
        }
        Settings.setSetting((String)"rapidminer.logging.log-file", tmpLog != null ? tmpLog.toAbsolutePath().toString() : null);
    }

    private static void writeLogFileToWorkingDirectory(Path targetFile) {
        PreLaunchMigrationManager.log(Level.INFO, "Finished all pre-launch migration processes.");
        String logFile = Settings.getSetting((String)"rapidminer.logging.log-file");
        if (logFile != null) {
            Path sourceFile = Path.of(logFile, new String[0]);
            try {
                Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                PreLaunchMigrationManager.log(Level.SEVERE, "Failed to copy migration.log into the working directory.");
            }
        }
    }

    private static void log(Level level, String toLog) {
        LogService.getRoot().log(level, toLog);
    }
}

