/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.launcher;

import com.rapidminer.gui.ApplicationFrame;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

final class RebootAnnouncer {
    private RebootAnnouncer() {
    }

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        JFrame frame = new JFrame("Altair AI Studio Updater");
        ImageIcon img = new ImageIcon(RebootAnnouncer.class.getResource("/rapidminer_frame_icon_128.png"));
        frame.setIconImage(img.getImage());
        JPanel contentPanel = new JPanel(new GridBagLayout());
        String message = "";
        message = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "<html><div style=\"width:400px\"><p style=\"font-weight:bold;margin-bottom:10px;\">This update of Altair AI Studio requires a system reboot.</p><p style=\"font-weight:normal;\">You can either reboot now or, if that is not possible, start Altair AI Studio via the file <em>AI-Studio.bat</em> inside your Altair AI Studio installation directory.</p></div></html>" : "<html><div style=\"width:400px\"><p style=\"font-weight:bold;margin-bottom:10px;\">Please restart Altair AI Studio manually for the update changes to take effect.</p></div></html>";
        JLabel label = new JLabel();
        label.setText(message);
        label.setIcon(new ImageIcon(RebootAnnouncer.class.getResource("/information.png")));
        label.setIconTextGap(24);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.gridwidth = 0;
        contentPanel.add((Component)label, gbc);
        JButton okayButton = new JButton("Okay");
        okayButton.setMnemonic('O');
        okayButton.addActionListener(new ActionListener(){

            @Override
            @SuppressFBWarnings
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        contentPanel.add((Component)okayButton, gbc);
        frame.setAlwaysOnTop(true);
        frame.setContentPane(contentPanel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo((Component)ApplicationFrame.getApplicationFrame());
        frame.setVisible(true);
        frame.toFront();
    }
}

