/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.search;

import com.rapidminer.search.ExtensionItem;
import com.rapidminer.search.Rater;
import java.util.Locale;

class ExtensionItemRater
implements Rater<ExtensionItem> {
    private String term;
    private String termLowerCase;
    private String[] terms;

    ExtensionItemRater(String term) {
        if (term == null || term.trim().isEmpty()) {
            throw new IllegalArgumentException("The parameter term is null or only whitespace.");
        }
        this.term = term;
        this.termLowerCase = term.toLowerCase(Locale.ENGLISH);
        this.terms = this.termLowerCase.trim().split("\\s+");
    }

    @Override
    public int rate(ExtensionItem extension) {
        int score = 0;
        String extensionName = extension.getName();
        String extensionNameLowercase = extensionName.toLowerCase(Locale.ENGLISH);
        if (extensionName.startsWith(this.term)) {
            score += 7 * this.terms.length;
        } else if (extensionNameLowercase.startsWith(this.termLowerCase)) {
            score += 6 * this.terms.length;
        } else if (extensionName.contains(this.term)) {
            score += 4 * this.terms.length;
        }
        if (this.term.length() > 1 && extension.getDescription().contains(this.term)) {
            score += 2 * this.terms.length;
        }
        if (score == 0) {
            String name = extensionNameLowercase;
            String description = extension.getDescription().toLowerCase();
            for (String subTerm : this.terms) {
                if (name.contains(subTerm)) {
                    score += 2;
                    continue;
                }
                if (this.term.length() > 1 && description.contains(subTerm)) {
                    ++score;
                    continue;
                }
                score = 0;
                break;
            }
        }
        return score;
    }
}

