/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.search;

import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.search.ExtensionError;
import com.rapidminer.search.ExtensionItem;
import com.rapidminer.search.ExtensionItemRater;
import com.rapidminer.search.ExtensionWrapper;
import com.rapidminer.search.MarketplaceGlobalSearch;
import com.rapidminer.search.MarketplaceGlobalSearchManager;
import com.rapidminer.settings.Telemetry;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.WebServiceTools;
import com.rapidminer.tools.nexus.NexusUtilities;
import com.rapidminer.tools.plugin.ManagedExtension;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.stream.Collectors;

public enum ExtensionService {
    INSTANCE;

    private MarketplaceGlobalSearchManager globalSearchManager;
    private volatile boolean isQuerying = false;
    private static final long DEPRECATION_TIME = 86400000L;
    private static final long RETRY_TIME = 60000L;
    private static final String PROGRESS_THREAD_ID = "load_extension_cache";
    private List<ExtensionItem> cachedExtensionItems;
    private long lastUpdate;
    private String lastUpdateUrl = "";
    private int installedExtensionsHash;
    private volatile boolean isMarketplaceReachable = true;
    private ProgressThread extensionItemQuery = new ProgressThread("load_extension_cache", false){

        public void run() {
            ExtensionService.this.updateCache();
        }
    };

    private ExtensionService() {
        this.extensionItemQuery.setIndeterminate(true);
        this.extensionItemQuery.addDependency(new String[]{PROGRESS_THREAD_ID});
    }

    public List<ExtensionItem> find(String term) {
        if (term == null || term.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ExtensionItemRater rater = new ExtensionItemRater(term);
        List<ExtensionItem> items = this.getExtensionItems();
        HashMap<ExtensionItem, Integer> result = new HashMap<ExtensionItem, Integer>();
        Comparator desc = (x, y) -> ((Integer)y.getValue()).compareTo((Integer)x.getValue());
        for (ExtensionItem item : items) {
            int score = rater.rate(item);
            if (score <= 0) continue;
            result.put(item, score);
        }
        return result.entrySet().stream().sorted(desc).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean isReady() {
        return this.cachedExtensionItems != null && !this.isUpdateNecessary();
    }

    public void fetchExtensions() {
        if (Telemetry.MARKETPLACE.isDenied()) {
            LogService.getRoot().config("com.rapidminer.search.ExtensionService.accessing_online_services_disallowed");
            return;
        }
        if (!this.isQuerying) {
            this.extensionItemQuery.start();
        }
    }

    public boolean isMarketplaceReachable() {
        if (!this.isReady()) {
            this.fetchExtensions();
        }
        return this.isMarketplaceReachable;
    }

    public List<ExtensionItem> getExtensionItems() {
        if (!this.isReady()) {
            this.updateCache();
        }
        if (this.cachedExtensionItems != null) {
            return Collections.unmodifiableList(this.cachedExtensionItems);
        }
        return Collections.emptyList();
    }

    private synchronized void updateCache() {
        if (Telemetry.MARKETPLACE.isDenied()) {
            LogService.getRoot().config("com.rapidminer.search.ExtensionService.accessing_online_services_disallowed");
            return;
        }
        if (this.isUpdateNecessary()) {
            this.isQuerying = true;
            List<ExtensionItem> queryResult = ExtensionService.queryExtensionItems();
            if (queryResult == null) {
                this.isMarketplaceReachable = false;
                this.cachedExtensionItems = Collections.emptyList();
            } else {
                LinkedList<ExtensionItem> mutable = new LinkedList<ExtensionItem>(queryResult);
                mutable.removeAll(ExtensionService.filterInstalledExtensions(queryResult));
                this.cachedExtensionItems = mutable;
                this.isMarketplaceReachable = true;
            }
            this.lastUpdate = System.currentTimeMillis();
            this.lastUpdateUrl = ParameterService.getParameterValue((String)"rapidminer.update.url");
            this.installedExtensionsHash = ManagedExtension.getAll().hashCode();
            this.isQuerying = false;
            if (this.globalSearchManager != null && this.globalSearchManager.isInitialized()) {
                this.globalSearchManager.updateMarketplaceContent();
            }
        }
    }

    private boolean isUpdateNecessary() {
        long diff = System.currentTimeMillis() - this.lastUpdate;
        if (diff > 86400000L) {
            return true;
        }
        if (this.installedExtensionsHash != ManagedExtension.getAll().hashCode()) {
            return true;
        }
        String updateUrl = ParameterService.getParameterValue((String)"rapidminer.update.url");
        if (updateUrl != null && !updateUrl.equals(this.lastUpdateUrl)) {
            return true;
        }
        return !this.isMarketplaceReachable && diff > 60000L;
    }

    private static List<ExtensionItem> filterInstalledExtensions(List<ExtensionItem> extensionItems) {
        ArrayList<ExtensionItem> installed = new ArrayList<ExtensionItem>();
        Collection managed = ManagedExtension.getAll();
        block0: for (ManagedExtension extension : managed) {
            for (ExtensionItem item : extensionItems) {
                if (!extension.isActive() || !extension.getPackageId().equals(item.getId())) continue;
                installed.add(item);
                continue block0;
            }
        }
        return installed;
    }

    private static List<ExtensionItem> queryExtensionItems() {
        ExtensionItem[] result = null;
        String url = ExtensionService.buildUrl();
        try {
            result = ExtensionService.readExtensionListFromUrl(url);
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "com.rapidminer.gui.local.search.ExtensionService.extensions_load_failed", e.getMessage());
        }
        return result != null ? Arrays.asList(result) : null;
    }

    private static ExtensionItem[] readExtensionListFromUrl(String urlString) throws IOException {
        String contentString;
        int statusCode;
        if (Telemetry.MARKETPLACE.isDenied()) {
            LogService.getRoot().config("com.rapidminer.search.ExtensionService.accessing_online_services_disallowed");
            return null;
        }
        ExtensionItem[] result = null;
        try {
            URL url = new URL(urlString);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            WebServiceTools.setURLConnectionDefaults((URLConnection)urlConnection);
            statusCode = urlConnection.getResponseCode();
            contentString = FileUtils.readText((InputStream)urlConnection.getInputStream());
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        if (contentString.trim().isEmpty()) {
            LogService.getRoot().log(Level.WARNING, "com.rapidminer.gui.local.search.ExtensionService.extensions_load_failed.empty_result", statusCode);
            return null;
        }
        switch (statusCode) {
            case 200: {
                result = ((ExtensionWrapper)NexusUtilities.parseJacksonString((String)contentString, ExtensionWrapper.class)).getData();
                break;
            }
            case 400: {
                ExtensionError eE = (ExtensionError)NexusUtilities.parseJacksonString((String)contentString, ExtensionError.class);
                LogService.getRoot().log(Level.WARNING, "com.rapidminer.gui.local.search.ExtensionService.extensions_load_failed", eE.getErrorMessage());
                break;
            }
            default: {
                LogService.getRoot().log(Level.WARNING, "com.rapidminer.gui.local.search.ExtensionService.extensions_load_failed.server_error", statusCode);
            }
        }
        return result;
    }

    private static String buildUrl() {
        String baseUrl = ParameterService.getParameterValue((String)"rapidminer.update.url");
        String path = I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.extension.json.url", (Object[])new Object[0]);
        String queryParam = I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.extension.json.version", (Object[])new Object[0]);
        VersionNumber vN = new VersionNumber(PlatformUtilities.getTechnicalReleaseVersion());
        String majorToPatchVersion = vN.getShortVersion() + "." + vN.getPatchLevel();
        String sep = path.contains("?") ? "&" : "?";
        return baseUrl + path + sep + queryParam + "=" + majorToPatchVersion;
    }

    public void setGlobalSearchManager(MarketplaceGlobalSearch globalSearch) {
        if (this.globalSearchManager == null) {
            this.globalSearchManager = (MarketplaceGlobalSearchManager)globalSearch.getSearchManager();
        }
    }
}

