/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.search;

import com.rapidminer.gui.search.GlobalSearchGUIUtilities;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.search.AbstractGlobalSearchManager;
import com.rapidminer.search.ExtensionItem;
import com.rapidminer.search.ExtensionService;
import com.rapidminer.search.GlobalSearchCategory;
import com.rapidminer.search.GlobalSearchDefaultField;
import com.rapidminer.search.GlobalSearchRegistry;
import com.rapidminer.search.GlobalSearchResult;
import com.rapidminer.search.GlobalSearchResultBuilder;
import com.rapidminer.search.GlobalSearchUtilities;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.parameter.ParameterChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryparser.classic.ParseException;

public class MarketplaceGlobalSearchManager
extends AbstractGlobalSearchManager {
    private static final Map<String, String> ADDITIONAL_FIELDS = new HashMap<String, String>();
    private static final String FIELD_LONG_DESCRIPTION = "longDescription";
    private static final String VENDOR_RAPIDMINER_REGEX = "Rap\\SdM\\Sner";
    private static final float FIELD_BOOST_DESCRIPTION = 0.5f;
    private static final float FIELD_BOOST_LONG_DESCRIPTION = 0.25f;
    public static final String VENDOR_RAPIDMINER_ID = "1002";
    public static final String VENDOR_RAPIDLAB_ID = "6041";
    public static final String FIELD_VENDOR = "vendor";
    public static final String FIELD_VENDOR_ID = "vendorId";
    public static final String FIELD_DESCRIPTION = "description";

    MarketplaceGlobalSearchManager() {
        super("marketplace", ADDITIONAL_FIELDS, new GlobalSearchDefaultField[]{new GlobalSearchDefaultField(FIELD_DESCRIPTION, 0.5f), new GlobalSearchDefaultField(FIELD_LONG_DESCRIPTION, 0.25f)});
    }

    protected void init() {
        ParameterService.registerParameterChangeListener((ParameterChangeListener)new ParameterChangeListener(){

            public void informParameterChanged(String key, String value) {
                if ("rapidminer.update.url".equals(key)) {
                    MarketplaceGlobalSearchManager.this.updateMarketplaceContent();
                }
            }

            public void informParameterSaved() {
            }
        });
    }

    protected List<Document> createInitialIndex() {
        return this.createDocuments();
    }

    public void updateMarketplaceContent() {
        ProgressThread pgUpdate = new ProgressThread("global_search.marketplace.update_index", false){

            public void run() {
                GlobalSearchResultBuilder builder = new GlobalSearchResultBuilder("category:" + MarketplaceGlobalSearchManager.this.getSearchCategoryId());
                builder.setMaxNumberOfResults(Integer.MAX_VALUE).setSearchCategories(new GlobalSearchCategory[]{GlobalSearchRegistry.INSTANCE.getSearchCategoryById(MarketplaceGlobalSearchManager.this.getSearchCategoryId())});
                try {
                    GlobalSearchResult result = builder.runSearch();
                    MarketplaceGlobalSearchManager.this.removeDocumentsFromIndex(result.getResultDocuments());
                }
                catch (ParseException e) {
                    LogService.getRoot().log(Level.WARNING, "com.rapidminer.repository.global_search.MarketplaceGlobalSearchManager.error.delete_all_documents", e);
                }
                MarketplaceGlobalSearchManager.this.addDocumentsToIndex(MarketplaceGlobalSearchManager.this.createDocuments());
            }
        };
        pgUpdate.setIndeterminate(true);
        pgUpdate.start();
    }

    private List<Document> createDocuments() {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (ExtensionItem item : ExtensionService.INSTANCE.getExtensionItems()) {
            Document document = this.createDocument(item);
            if (document == null) continue;
            documents.add(document);
        }
        return documents;
    }

    private Document createDocument(ExtensionItem item) {
        String vendor;
        ArrayList<Field> fields = new ArrayList<Field>();
        String description = item.getDescription() != null ? item.getDescription() : "";
        String longDescription = item.getLongDescription() != null ? item.getLongDescription() : "";
        String vendorId = item.getVendorId() != null ? item.getVendorId() : "";
        String string = vendor = item.getVendor() != null ? item.getVendor() : "";
        if (this.isImpersonator(vendor, vendorId)) {
            return null;
        }
        fields.add(GlobalSearchUtilities.INSTANCE.createFieldForTexts(FIELD_DESCRIPTION, GlobalSearchGUIUtilities.INSTANCE.createTextFromHTML(description)));
        fields.add(GlobalSearchUtilities.INSTANCE.createFieldForTexts(FIELD_LONG_DESCRIPTION, GlobalSearchGUIUtilities.INSTANCE.createTextFromHTML(longDescription)));
        fields.add(GlobalSearchUtilities.INSTANCE.createFieldForTexts(FIELD_VENDOR, vendor));
        fields.add(GlobalSearchUtilities.INSTANCE.createFieldForTexts(FIELD_VENDOR_ID, vendorId));
        return GlobalSearchUtilities.INSTANCE.createDocument(item.getId(), item.getName(), fields.toArray(new Field[fields.size()]));
    }

    private boolean isImpersonator(String vendor, String vendorId) {
        return vendor.matches(VENDOR_RAPIDMINER_REGEX) && !VENDOR_RAPIDMINER_ID.equals(vendorId) && !VENDOR_RAPIDLAB_ID.equals(vendorId);
    }

    static {
        ADDITIONAL_FIELDS.put(FIELD_DESCRIPTION, "The short description of the extension on the Marketplace");
        ADDITIONAL_FIELDS.put(FIELD_LONG_DESCRIPTION, "The long description of the extension on the Marketplace");
        ADDITIONAL_FIELDS.put(FIELD_VENDOR, "The vendor of the extension on the Marketplace");
    }
}

