/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.update.internal;

import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.update.client.ExtensionDialog;
import com.rapidminer.deployment.update.client.MarketplaceUpdateManager;
import com.rapidminer.deployment.update.client.UpdateDialog;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.extensions.IncompatibleExtensionsDialog;
import com.rapidminer.gui.globalsearch.MarketplaceGlobalSearchGUIProvider;
import com.rapidminer.gui.internal.GUIStartupListener;
import com.rapidminer.gui.local.search.MarketplacePanelDefault;
import com.rapidminer.gui.local.search.MarketplacePanelSearch;
import com.rapidminer.gui.processeditor.NewOperatorEditor;
import com.rapidminer.gui.processeditor.NewOperatorGroupTree;
import com.rapidminer.gui.search.GlobalSearchGUIRegistry;
import com.rapidminer.gui.search.GlobalSearchableGUIProvider;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.search.ExtensionService;
import com.rapidminer.search.GlobalSearchIndexer;
import com.rapidminer.search.GlobalSearchRegistry;
import com.rapidminer.search.MarketplaceGlobalSearch;
import com.rapidminer.settings.Telemetry;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RMUrlHandler;
import com.rapidminer.tools.plugin.Plugin;
import com.rapidminer.tools.update.internal.UpdateManager;
import com.rapidminer.tools.update.internal.UpdateManagerFactory;
import com.rapidminer.tools.update.internal.UpdateManagerRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MarketplaceGUIStartupListener
implements GUIStartupListener {
    public void splashWillBeShown() {
        UpdateManagerRegistry.INSTANCE.register(new UpdateManagerFactory(){

            public UpdateManager create() throws MalformedURLException, URISyntaxException, IOException {
                return new MarketplaceUpdateManager(MarketplaceUpdateManager.getService());
            }
        });
        RapidMiner.registerParameter((ParameterType)new ParameterTypeBoolean("rapidminer.update.incremental", "", true));
        RapidMiner.registerParameter((ParameterType)new ParameterTypeString("rapidminer.update.url", "", "https://marketplace.rapidminer.com/UpdateServer"));
    }

    public void mainFrameInitialized(final MainFrame mainFrame) {
        if (Telemetry.MARKETPLACE.isDenied()) {
            LogService.getRoot().config("com.rapidminer.update.internal.MarketplaceGUIStartupListener.accessing_online_services_disallowed");
            return;
        }
        mainFrame.getExtensionsMenu().add(UpdateDialog.UPDATE_ACTION);
        mainFrame.getExtensionsMenu().add(ExtensionDialog.MANAGE_EXTENSIONS);
        ((ResourceAction)UpdateDialog.UPDATE_ACTION).addToGlobalSearch();
        ((ResourceAction)ExtensionDialog.MANAGE_EXTENSIONS).addToGlobalSearch();
        RMUrlHandler.register((String)"marketplace", (Action)UpdateDialog.UPDATE_ACTION);
        RMUrlHandler.register((String)"marketplace-updates", (Action)UpdateDialog.UPDATE_TAB_ACTION);
        RMUrlHandler.register((String)"manage_extensions", (Action)ExtensionDialog.MANAGE_EXTENSIONS);
        Collection sortedPlugins = Plugin.getAllPlugins();
        if (!sortedPlugins.isEmpty()) {
            boolean showExtensionsMenu = false;
            ResourceMenu extensionsMenu = new ResourceMenu("about_extensions");
            for (final Plugin plugin : sortedPlugins) {
                if (!plugin.showAboutBox()) continue;
                showExtensionsMenu = true;
                extensionsMenu.add((Action)new ResourceAction("about_extension", new Object[]{plugin.getName()}){
                    private static final long serialVersionUID = 1L;

                    public void loggedActionPerformed(ActionEvent e) {
                        plugin.createAboutBox((Frame)mainFrame).setVisible(true);
                    }
                });
            }
            if (showExtensionsMenu) {
                mainFrame.getExtensionsMenu().add((JMenuItem)extensionsMenu);
            }
        }
        final NewOperatorEditor operatorDockable = (NewOperatorEditor)mainFrame.getDockingDesktop().getContext().getDockableByKey("new_operator");
        final NewOperatorGroupTree tree = operatorDockable.getNewOperatorGroupTree();
        final MarketplacePanelDefault defaultPanel = new MarketplacePanelDefault();
        final MarketplacePanelSearch searchingPanel = new MarketplacePanelSearch();
        if (JComponent.class.isAssignableFrom(operatorDockable.getComponent().getClass())) {
            JComponent parent = (JComponent)operatorDockable.getComponent();
            searchingPanel.setParent(parent);
            parent.add((Component)defaultPanel, "South");
        }
        tree.getFilterField().getDocument().addDocumentListener(new DocumentListener(){
            JComponent parent;
            {
                this.parent = (JComponent)operatorDockable.getComponent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!Telemetry.MARKETPLACE.isDenied() && ExtensionService.INSTANCE.isMarketplaceReachable()) {
                    this.parent.remove(defaultPanel);
                    searchingPanel.search(tree.getFilterField().getText());
                    this.parent.add((Component)searchingPanel, "South");
                    this.parent.revalidate();
                    this.parent.repaint();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!Telemetry.MARKETPLACE.isDenied()) {
                    if (tree.getFilterField().getText().isEmpty()) {
                        this.parent.remove(searchingPanel);
                        this.parent.add((Component)defaultPanel, "South");
                        searchingPanel.reset();
                        this.parent.revalidate();
                        this.parent.repaint();
                    } else if (ExtensionService.INSTANCE.isMarketplaceReachable()) {
                        searchingPanel.search(tree.getFilterField().getText());
                        this.parent.revalidate();
                        this.parent.repaint();
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public void splashWasHidden() {
        ExtensionService.INSTANCE.setGlobalSearchManager(new MarketplaceGlobalSearch());
        if (!Telemetry.MARKETPLACE.isDenied() && GlobalSearchRegistry.INSTANCE.getSearchCategoryById("marketplace") != null) {
            GlobalSearchGUIRegistry.INSTANCE.registerSearchVisualizationProvider(GlobalSearchRegistry.INSTANCE.getSearchCategoryById("marketplace"), (GlobalSearchableGUIProvider)new MarketplaceGlobalSearchGUIProvider());
        }
    }

    public void startupCompleted() {
        if (!GlobalSearchIndexer.INSTANCE.isInitialized()) {
            ExtensionService.INSTANCE.fetchExtensions();
        }
        if (RapidMiner.getDisplayVersion().isSnapshot()) {
            return;
        }
        if (!Plugin.getFailedPlugins().isEmpty()) {
            SwingTools.invokeLater(() -> {
                IncompatibleExtensionsDialog dialog = new IncompatibleExtensionsDialog();
                dialog.setVisible(true);
            });
        } else {
            MarketplaceUpdateManager.checkForUpdates();
        }
    }
}

