/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.update.internal;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.settings.Telemetry;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.WebServiceTools;
import com.rapidminer.tools.nexus.NexusUtilities;
import com.rapidminer.tools.update.internal.UpgradeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;

public enum UpgradeNotificationService {
    INSTANCE;

    protected static final String JSON_URL_KEY = "gui.label.upgrade_notification.json.url";
    protected static final String DEFAULT_MESSAGE_KEY = "gui.label.upgrade_notification.default_message";
    private static final String LOADING_FAILED_KEY = "com.rapidminer.gui.startup.UpgradeNotificationService.upgrade_messages_load_failed";
    private static final String JSON_URL;
    private static final String DEFAULT_MESSAGE;
    private static final Object UPDATE_LOCK;
    private static final long DEPRECATION_TIME;
    private static final String PROGRESS_THREAD_ID = "load_upgrade_notifications";
    private long lastUpdate;
    private boolean forceUpdate;
    private List<UpgradeMessage> cachedUpgradeMessages;
    private ProgressThread upgradeMessageQuery = new ProgressThread("load_upgrade_notifications", false){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = UPDATE_LOCK;
            synchronized (object) {
                List<UpgradeMessage> queryResult;
                if (UpgradeNotificationService.this.isUpdateNecessary() && (queryResult = this.queryUpgradeMessages()) != null) {
                    ArrayList<UpgradeMessage> safeList = new ArrayList<UpgradeMessage>(queryResult);
                    Predicate<UpgradeMessage> messageForPreviousVersion = m -> RapidMiner.getDisplayVersion().isAtLeast(m.getCurrentVersionLessThan());
                    Comparator<UpgradeMessage> orderByTargetVersionAsc = Comparator.comparing(UpgradeMessage::getTargetVersionLessThan);
                    Comparator<UpgradeMessage> orderByCurrentVersionAsc = Comparator.comparing(UpgradeMessage::getCurrentVersionLessThan);
                    safeList.removeIf(messageForPreviousVersion);
                    safeList.sort(orderByTargetVersionAsc.thenComparing(orderByCurrentVersionAsc));
                    UpgradeNotificationService.this.cachedUpgradeMessages = safeList;
                    UpgradeNotificationService.this.lastUpdate = System.currentTimeMillis();
                    UpgradeNotificationService.this.forceUpdate = false;
                }
            }
        }

        private List<UpgradeMessage> queryUpgradeMessages() {
            UpgradeMessage[] result = null;
            try {
                result = this.readMessagesFromUrl(JSON_URL);
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, UpgradeNotificationService.LOADING_FAILED_KEY, e.getMessage());
            }
            return result != null ? Arrays.asList(result) : null;
        }

        private UpgradeMessage[] readMessagesFromUrl(String urlString) throws IOException {
            String contentString;
            if (Telemetry.MARKETPLACE.isDenied()) {
                return null;
            }
            try {
                URLConnection connection = new URL(urlString).openConnection();
                WebServiceTools.setURLConnectionDefaults((URLConnection)connection);
                contentString = FileUtils.readText((InputStream)connection.getInputStream());
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
            if (contentString.trim().isEmpty()) {
                return new UpgradeMessage[0];
            }
            return (UpgradeMessage[])NexusUtilities.parseJacksonString((String)contentString, UpgradeMessage[].class);
        }
    };

    private UpgradeNotificationService() {
        this.upgradeMessageQuery.setIndeterminate(true);
        this.upgradeMessageQuery.addDependency(new String[]{PROGRESS_THREAD_ID});
    }

    public List<UpgradeMessage> getUpgradeMessages() {
        if (this.cachedUpgradeMessages == null || this.isUpdateNecessary()) {
            this.upgradeMessageQuery.startAndWait();
        }
        if (this.cachedUpgradeMessages != null) {
            return new LinkedList<UpgradeMessage>(this.cachedUpgradeMessages);
        }
        return Collections.emptyList();
    }

    private boolean isUpdateNecessary() {
        if (Telemetry.MARKETPLACE.isDenied()) {
            return false;
        }
        if (this.lastUpdate <= 0L || this.forceUpdate) {
            return true;
        }
        long diff = System.currentTimeMillis() - this.lastUpdate;
        return diff > DEPRECATION_TIME;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }

    public String getMessage(VersionNumber targetVersion) {
        if (targetVersion == null) {
            return DEFAULT_MESSAGE;
        }
        Predicate<UpgradeMessage> belowTargetVersion = m -> m.getTargetVersionLessThan().isAbove(targetVersion);
        return this.getUpgradeMessages().stream().filter(belowTargetVersion).findFirst().map(UpgradeMessage::getMessage).orElse(DEFAULT_MESSAGE);
    }

    static {
        JSON_URL = I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)JSON_URL_KEY, (Object[])new Object[0]);
        DEFAULT_MESSAGE = I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)DEFAULT_MESSAGE_KEY, (Object[])new Object[0]);
        UPDATE_LOCK = new Object();
        DEPRECATION_TIME = TimeUnit.DAYS.toMillis(1L);
    }
}

