/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BufferBacked;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.vector.util.TransferPair;

public class RunEndEncodedVector
extends BaseValueVector
implements FieldVector {
    public static final FieldVector DEFAULT_VALUE_VECTOR = ZeroVector.INSTANCE;
    public static final FieldVector DEFAULT_RUN_END_VECTOR = ZeroVector.INSTANCE;
    protected final CallBack callBack;
    protected Field field;
    protected FieldVector runEndsVector;
    protected FieldVector valuesVector;
    protected int valueCount;

    public static RunEndEncodedVector empty(String name, BufferAllocator allocator) {
        return new RunEndEncodedVector(name, allocator, FieldType.notNullable(ArrowType.RunEndEncoded.INSTANCE), null);
    }

    public RunEndEncodedVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        this(new Field(name, fieldType, null), allocator, callBack);
    }

    public RunEndEncodedVector(Field field, BufferAllocator allocator, CallBack callBack) {
        this(field, allocator, DEFAULT_RUN_END_VECTOR, DEFAULT_VALUE_VECTOR, callBack);
    }

    public RunEndEncodedVector(Field field, BufferAllocator allocator, FieldVector runEndsVector, FieldVector valuesVector, CallBack callBack) {
        super(allocator);
        this.field = field;
        this.callBack = callBack;
        this.valueCount = 0;
        this.runEndsVector = runEndsVector;
        this.valuesVector = valuesVector;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.initializeChildrenFromFields(this.field.getChildren());
        for (FieldVector v : this.getChildrenFromFields()) {
            boolean isAllocated = v.allocateNewSafe();
            if (isAllocated) continue;
            v.clear();
            return false;
        }
        return true;
    }

    @Override
    public void reAlloc() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.reAlloc();
        }
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    protected FieldReader getReaderImpl() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return this.getChildrenFromFields().stream().mapToInt(item -> item != null ? item.getValueCapacity() : 0).min().orElseThrow(NoSuchElementException::new);
    }

    @Override
    public void close() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.close();
        }
    }

    @Override
    public void clear() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.clear();
        }
    }

    @Override
    public void reset() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.reset();
        }
        this.valueCount = 0;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.RUNENDENCODED;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        throw new UnsupportedOperationException("RunEndEncodedVector does not support getTransferPair(BufferAllocator)");
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.getTransferPair(field, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        throw new UnsupportedOperationException("RunEndEncodedVector does not support getTransferPair(String, BufferAllocator, CallBack)");
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        throw new UnsupportedOperationException("RunEndEncodedVector does not support getTransferPair(Field, BufferAllocator, CallBack)");
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        throw new UnsupportedOperationException("RunEndEncodedVector does not support makeTransferPair(ValueVector)");
    }

    @Override
    public FieldReader getReader() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public FieldWriter getWriter() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public int getBufferSize() {
        int bufferSize = 0;
        for (FieldVector v : this.getChildrenFromFields()) {
            bufferSize += v.getBufferSize();
        }
        return bufferSize;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        return new ArrowBuf[0];
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a validity buffer.");
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a data buffer.");
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a offset buffer.");
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public Object getObject(int index) {
        this.checkIndex(index);
        int physicalIndex = this.getPhysicalIndex(index);
        return this.valuesVector.getObject(physicalIndex);
    }

    public int getRunEnd(int index) {
        this.checkIndex(index);
        int physicalIndex = this.getPhysicalIndex(index);
        return (int)((BaseIntVector)this.runEndsVector).getValueAsLong(physicalIndex);
    }

    @Override
    public int getNullCount() {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        int physicalIndex = RunEndEncodedVector.getPhysicalIndex(this.runEndsVector, index);
        return this.valuesVector.isNull(physicalIndex);
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        int hash = 0;
        for (FieldVector v : this.getChildrenFromFields()) {
            if (index >= v.getValueCount()) continue;
            hash = ByteFunctionHelpers.combineHash(hash, v.hashCode(index, hasher));
        }
        return hash;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.unmodifiableCollection(this.getChildrenFromFields()).iterator();
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        Preconditions.checkArgument(children.size() == 2, "Run-end encoded vectors must have two child Fields. Found: %s", children.isEmpty() ? "none" : children);
        Preconditions.checkArgument(Arrays.asList(Types.MinorType.SMALLINT.getType(), Types.MinorType.INT.getType(), Types.MinorType.BIGINT.getType()).contains(children.get(0).getType()), "The first field represents the run-end vector and must be of type int with size 16, 32, or 64 bits. Found: %s", (Object)children.get(0).getType());
        this.runEndsVector = (BaseIntVector)children.get(0).createVector(this.allocator);
        this.valuesVector = children.get(1).createVector(this.allocator);
        this.field = new Field(this.field.getName(), this.field.getFieldType(), children);
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Arrays.asList(this.runEndsVector, this.valuesVector);
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (!ownBuffers.isEmpty()) {
            throw new UnsupportedOperationException("Run-end encoded vectors do not have any associated buffers.");
        }
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        return List.of();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers().");
    }

    @Override
    public long getValidityBufferAddress() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a validity buffer.");
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a data buffer.");
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have an offset buffer.");
    }

    @Override
    public void setNull(int index) {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a validity buffer.");
    }

    public FieldVector getRunEndsVector() {
        return this.runEndsVector;
    }

    public FieldVector getValuesVector() {
        return this.valuesVector;
    }

    private void checkIndex(int logicalIndex) {
        if (logicalIndex < 0 || logicalIndex >= this.valueCount) {
            throw new IndexOutOfBoundsException(String.format("index: %s, expected range (0, %s)", logicalIndex, this.valueCount));
        }
    }

    public int getPhysicalIndex(int logicalIndex) {
        return RunEndEncodedVector.getPhysicalIndex(this.runEndsVector, logicalIndex);
    }

    static int getPhysicalIndex(FieldVector runEndVector, int logicalIndex) {
        if (runEndVector == null || runEndVector.getValueCount() == 0) {
            return -1;
        }
        int low = 0;
        int high = runEndVector.getValueCount() - 1;
        int result = -1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            long valueAsLong = ((BaseIntVector)runEndVector).getValueAsLong(mid);
            if (valueAsLong > (long)logicalIndex) {
                result = mid;
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return result;
    }
}

