from pandas import DataFrame

# Mandatory training function. When implementing a forecasting model, the
# input data will be split into index and series. Series contains the columns of
# the data except the index. Parameters are passed in as plain Python dictionary.
# By default, this dictionary already contains the index_name and series_name keys
# pointing to the column names specified in the operator parameters.
def rm_train(index, series, parameters):
    # This example does not make use of the parameter to configure the model.
	# However, printing the dictionary will show its values in the log.
	# It also contains the name of the time series attribute and the name of
	# the index.
	print(parameters)
	# It is also possible to check the values of the index and series the same
	# way.
	print(index)
	print(series)
	# You can return any Python object as model. A trained model, for example, and
	# return it to pass it to the rm_apply function.
	model = 2
	return {
		'model': model
	}

# Mandatory application function. The model is the same type as the model returned
# during training. The horizon parameter is specified in the Apply Forecast operator.
# It declares how many values the forecast rm_apply will produce.
def rm_apply(model, horizon):
	# Run the trained model with the new data
    # Return it as a pandas DataFrame
    forecast = [x * model['model'] for x in range(horizon)]
    print(forecast)
    return DataFrame({'values': forecast})
