from pandas import DataFrame
from sklearn.naive_bayes import GaussianNB

# Mandatory training function. When implementing a supervised learner, the
# input data will be split into the feature vector X and the label vector y.
# Parameters are passed in as plain Python dictionary.
def rm_train(X, y, parameters):
	# This example does not make use of the parameter to configure the model.
	# However, printing the dictionary will show its values in the log.
	print(parameters)
	# You can return any Python object as model. Sci-kit learn classifiers such
	# as the Gaussian Naive Bayes are just one example.
	clf = GaussianNB()
	model = clf.fit(X, y)
	return model

# Mandatory application function. The input data set X is guaranteed to have
# have the same columns and column order as seen during training. The model is
# the of the same type as the model return during training.
def rm_apply(X, model):
	prediction = DataFrame(model.predict(X))
	probabilities = DataFrame(model.predict_proba(X))
	probabilities.columns = model.classes_
	# The first return value must be a Pandas DataFrame with a single column
	# and of the size as X. The second return value is optional and can be used
	# to return probabilities (if any).
	return prediction, probabilities
