/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.samples.operator;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.execution.Context;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.storage.hdf5.Hdf5TableReader;
import com.rapidminer.storage.hdf5.HdfReaderException;
import com.rapidminer.tools.DirectoryService;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.belt.BeltTools;
import com.rapidminer.tools.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class GenerateDataSampleOperator
extends Operator {
    private static final String EXTENSION_ID = "rmx_samples";
    private static final String TABLE_SUFFIX = ".rmhdf5table";
    private static final String PARAMETER_SAMPLE = "sample";
    private static final String[] PARAMETER_SAMPLE_VALUES;
    private static final String VERSION;
    private static final Path TABLE_CACHE_DIR;
    private static final Map<String, TableMetaData> METADATA_CACHE;
    private final OutputPort tableOutput = (OutputPort)this.getOutputPorts().createPort("table");

    public GenerateDataSampleOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(this::updateTableMetaData);
    }

    public void doWork() throws OperatorException {
        String parameterValue = PARAMETER_SAMPLE_VALUES[this.getParameterAsInt(PARAMETER_SAMPLE)];
        Path tableFile = this.getTableFile(parameterValue);
        try {
            IOTable readTable = Hdf5TableReader.read((Path)tableFile, (Context)BeltTools.getContext((Operator)this));
            this.tableOutput.deliver((IOObject)readTable);
        }
        catch (HdfReaderException | IOException e) {
            throw new UserError((Operator)this, e, "samples.read_sample", new Object[]{parameterValue});
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_SAMPLE, "The data sample to create", PARAMETER_SAMPLE_VALUES, 0, false);
        type.setOptional(false);
        types.add(type);
        return types;
    }

    private void updateTableMetaData() {
        String parameterValue;
        try {
            parameterValue = PARAMETER_SAMPLE_VALUES[this.getParameterAsInt(PARAMETER_SAMPLE)];
        }
        catch (UndefinedParameterError e) {
            parameterValue = PARAMETER_SAMPLE_VALUES[0];
        }
        TableMetaData metaData = METADATA_CACHE.get(parameterValue);
        if (metaData == null) {
            try {
                Path tableFile = this.getTableFile(parameterValue);
                metaData = Hdf5TableReader.readMetaData((Path)tableFile, (boolean)false);
                METADATA_CACHE.put(parameterValue, metaData);
            }
            catch (UserError | IOException e) {
                LogService.getRoot().log(Level.WARNING, "Unable to read sample data for meta data: " + parameterValue, e);
                metaData = new TableMetaData();
            }
        }
        this.tableOutput.deliverMD((MetaData)metaData);
    }

    private Path getTableFile(String parameterValue) throws UserError {
        Path path;
        block17: {
            Path targetFile = TABLE_CACHE_DIR.resolve(parameterValue + TABLE_SUFFIX);
            if (Files.exists(targetFile, new LinkOption[0])) {
                return targetFile;
            }
            String resourcePath = "/com/altair/ai/resources/samples/" + parameterValue + TABLE_SUFFIX;
            InputStream is = GenerateDataSampleOperator.class.getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IOException("Sample data resource not found: " + parameterValue);
                }
                Path cacheFile = Files.createFile(targetFile, new FileAttribute[0]);
                try (OutputStream os = Files.newOutputStream(cacheFile, new OpenOption[0]);){
                    is.transferTo(os);
                }
                path = cacheFile;
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    FileUtils.deleteQuietly((Path)targetFile);
                    throw new UserError((Operator)this, (Throwable)e, "samples.read_resource", new Object[]{parameterValue});
                }
            }
            is.close();
        }
        return path;
    }

    private static String getExtensionVersion() {
        Plugin samples = Plugin.getPluginByExtensionId((String)EXTENSION_ID);
        return samples != null ? samples.getTechnicalVersion().getShortLongVersion() : "unknown";
    }

    private static void prepareCachingDir(Path extensionWorkspaceDir) {
        if (!Files.exists(TABLE_CACHE_DIR, new LinkOption[0])) {
            if (Files.exists(extensionWorkspaceDir, new LinkOption[0])) {
                FileUtils.deleteQuietly((Path)extensionWorkspaceDir);
            }
            try {
                Files.createDirectories(TABLE_CACHE_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.SEVERE, "Unable to create table cache directory: " + TABLE_CACHE_DIR, e);
            }
        }
    }

    static {
        METADATA_CACHE = new HashMap<String, TableMetaData>();
        PARAMETER_SAMPLE_VALUES = new String[]{"Deals", "Deals-Testset", "Golf", "Golf-Testset", "Iris", "Labor-Negotiations", "Market-Data", "Polynomial", "Products", "Purchases", "Ripley-Set", "Sonar", "Titanic", "Titanic Training", "Titanic Unlabeled", "Transactions", "Weighting"};
        VERSION = GenerateDataSampleOperator.getExtensionVersion();
        Path extensionWorkspaceDir = DirectoryService.getExtensionWorkspaceDir((String)EXTENSION_ID);
        TABLE_CACHE_DIR = extensionWorkspaceDir.resolve(VERSION);
        GenerateDataSampleOperator.prepareCachingDir(extensionWorkspaceDir);
    }
}

