/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.renderer;

import com.owc.objects.statistics.SurvivalCurveChartObject;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.report.Reportable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SurvivalCurveChartRenderer
extends AbstractRenderer
implements Reportable {
    public String getName() {
        return "Survival Curve";
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        SurvivalCurveChartObject chartObject = (SurvivalCurveChartObject)((Object)renderable);
        ExampleSet set = chartObject.getExampleSet();
        XYPlot plot = new XYPlot();
        String title = chartObject.getTitle();
        boolean plotWithConfidenceInterval = chartObject.isConfidenceIntervalShown();
        XYSeriesCollection dataSetSurvival = new XYSeriesCollection();
        XYSeriesCollection dataSetCensorship = new XYSeriesCollection();
        XYSeriesCollection dataSetLowerCI = new XYSeriesCollection();
        XYSeriesCollection dataSetUpperCI = new XYSeriesCollection();
        XYSeries seriesSurvival = new XYSeries((Comparable)((Object)chartObject.getAttributeKey()));
        XYSeries seriesCensorship = new XYSeries((Comparable)((Object)chartObject.getAttributeCensored()));
        XYSeries seriesLowerCI = null;
        XYSeries seriesUpperCI = null;
        if (plotWithConfidenceInterval) {
            seriesLowerCI = new XYSeries((Comparable)((Object)chartObject.getAttributeLowerCI()));
            seriesUpperCI = new XYSeries((Comparable)((Object)chartObject.getAttributeUpperCI()));
            dataSetLowerCI.addSeries(seriesLowerCI);
            dataSetUpperCI.addSeries(seriesUpperCI);
        }
        dataSetSurvival.addSeries(seriesSurvival);
        dataSetCensorship.addSeries(seriesCensorship);
        XYStepRenderer rendererSurvival = new XYStepRenderer();
        XYLineAndShapeRenderer rendererCensorship = new XYLineAndShapeRenderer(false, true);
        XYStepRenderer rendererLowerCI = new XYStepRenderer();
        XYStepRenderer rendererUpperCI = new XYStepRenderer();
        NumberAxis adjustDomain = new NumberAxis(chartObject.getDomainAxisName());
        NumberAxis adjustRange = new NumberAxis(chartObject.getRangeAxisName());
        plot.setDomainAxis(0, (ValueAxis)adjustDomain);
        plot.setRangeAxis(0, (ValueAxis)adjustRange);
        rendererSurvival.setSeriesPaint(0, (Paint)Color.red);
        rendererCensorship.setSeriesShape(0, (Shape)new Line2D.Double(0.0, -10.0, 0.0, 10.0));
        rendererCensorship.setSeriesPaint(0, (Paint)Color.black);
        rendererLowerCI.setSeriesStroke(0, (Stroke)new BasicStroke(0.5f, 2, 2, 10.0f, new float[]{16.0f, 16.0f}, 0.0f));
        rendererLowerCI.setSeriesPaint(0, (Paint)Color.GRAY);
        rendererUpperCI.setSeriesStroke(0, (Stroke)new BasicStroke(0.5f, 2, 0, 10.0f, new float[]{16.0f, 16.0f}, 0.0f));
        rendererUpperCI.setSeriesPaint(0, (Paint)Color.GRAY);
        plot.setDataset(1, (XYDataset)dataSetSurvival);
        plot.setDataset(0, (XYDataset)dataSetCensorship);
        if (plotWithConfidenceInterval) {
            plot.setDataset(2, (XYDataset)dataSetLowerCI);
            plot.setDataset(3, (XYDataset)dataSetUpperCI);
        }
        plot.setRenderer(1, (XYItemRenderer)rendererSurvival);
        plot.setRenderer(0, (XYItemRenderer)rendererCensorship);
        plot.setRenderer(2, (XYItemRenderer)rendererLowerCI);
        plot.setRenderer(3, (XYItemRenderer)rendererUpperCI);
        Attribute censorshipAttribute = set.getAttributes().get(chartObject.getAttributeCensored());
        Attribute timeAttribute = set.getAttributes().get(chartObject.getAttributeTime());
        Attribute valueAttribute = set.getAttributes().get(chartObject.getAttributeKey());
        Attribute lowerCIAttribute = set.getAttributes().get(chartObject.getAttributeLowerCI());
        Attribute upperCICIAttribute = set.getAttributes().get(chartObject.getAttributeUpperCI());
        for (Example example : set) {
            double time = example.getValue(timeAttribute);
            double value = example.getValue(valueAttribute);
            seriesSurvival.add(time, value);
            if (example.getValueAsString(censorshipAttribute).equals("true")) {
                seriesCensorship.add(time, value);
            }
            if (lowerCIAttribute == null || upperCICIAttribute == null) continue;
            double lowerCI = example.getValue(lowerCIAttribute);
            double upperCI = example.getValue(upperCICIAttribute);
            seriesLowerCI.add(time, lowerCI);
            seriesUpperCI.add(time, upperCI);
        }
        JFreeChart chart = new JFreeChart(title, (Plot)plot);
        chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setMaximumDrawWidth(Integer.MAX_VALUE);
        chartPanel.setMinimumDrawWidth(10);
        chartPanel.setMaximumDrawHeight(Integer.MAX_VALUE);
        chartPanel.setMinimumDrawHeight(10);
        JScrollPane resultPanel = new JScrollPane();
        resultPanel.setViewportView((Component)chartPanel);
        return resultPanel;
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        return this;
    }
}

