/*
 * Decompiled with CFR 0.152.
 */
package com.owc.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;

public class LicenseEncryption {
    public static final int AES_Key_Size = 128;
    Cipher pkCipher = Cipher.getInstance("RSA");
    Cipher aesCipher = Cipher.getInstance("AES");
    byte[] aesKey;
    SecretKeySpec aeskeySpec;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public LicenseEncryption() throws GeneralSecurityException {
        this.generateSymetricKey();
    }

    private void generateSymetricKey() throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        SecretKey key = kgen.generateKey();
        this.aesKey = key.getEncoded();
        this.aeskeySpec = new SecretKeySpec(this.aesKey, "AES");
    }

    void loadPrivateKey(InputStream pkInputStream) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.privateKey == null) {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(this.readStreamAsBytes(pkInputStream));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.privateKey = kf.generatePrivate(privateKeySpec);
        }
    }

    public PublicKey loadPublicKey(InputStream publicKeyStream) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(this.readStreamAsBytes(publicKeyStream));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.publicKey = kf.generatePublic(publicKeySpec);
        return this.publicKey;
    }

    public void setPublicKey(PublicKey key) {
        this.publicKey = key;
    }

    public void appendSymetricKey(OutputStream out) throws IOException, GeneralSecurityException {
        this.pkCipher.init(1, this.privateKey);
        CipherOutputStream os = new CipherOutputStream((OutputStream)new Base64OutputStream(out, true, -1, null), this.pkCipher);
        os.write(this.aesKey);
        os.close();
    }

    public void loadSymetricKey(InputStream inputStream) throws IOException, InvalidKeyException {
        this.pkCipher.init(2, this.publicKey);
        this.aesKey = new byte[16];
        CipherInputStream is = new CipherInputStream((InputStream)new Base64InputStream(inputStream, false, 0, null), this.pkCipher);
        is.read(this.aesKey);
        this.aeskeySpec = new SecretKeySpec(this.aesKey, "AES");
        is.close();
    }

    public void appendData(String data, OutputStream outputStream) throws InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException {
        this.aesCipher.init(1, this.aeskeySpec);
        CipherOutputStream os = new CipherOutputStream((OutputStream)new Base64OutputStream(outputStream, true, -1, null), this.aesCipher);
        os.write(data.getBytes("UTF-8"));
        os.close();
    }

    public String loadData(InputStream inputStream) throws InvalidKeyException, UnsupportedEncodingException, IOException {
        int read;
        this.aesCipher.init(2, this.aeskeySpec);
        CipherInputStream is = new CipherInputStream((InputStream)new Base64InputStream(inputStream, false, 0, null), this.aesCipher);
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-8");
        while ((read = in.read(buffer)) > 0) {
            out.append(buffer, 0, read);
        }
        ((Reader)in).close();
        return out.toString();
    }

    private byte[] readStreamAsBytes(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        int read = 0;
        while ((read = inputStream.read(buffer)) != -1) {
            outs.write(buffer, 0, read);
        }
        inputStream.close();
        outs.close();
        return outs.toByteArray();
    }
}

