/*
 * Decompiled with CFR 0.152.
 */
package com.owc.math.aggregation;

import com.owc.math.aggregation.NumericalStreamableAggregator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;

public class CountAggregator
implements NumericalStreamableAggregator {
    private Attribute sourceAttribute;
    private double count = 0.0;
    private boolean isIgnoringMissings = false;

    public CountAggregator(Attribute sourceAttribute, boolean isIgnoringMissings) {
        this.sourceAttribute = sourceAttribute;
        this.isIgnoringMissings = isIgnoringMissings;
    }

    @Override
    public void count(Example example) {
        if (!this.isIgnoringMissings) {
            this.count += 1.0;
        } else {
            double value = example.getValue(this.sourceAttribute);
            if (!Double.isNaN(value)) {
                this.count += 1.0;
            }
        }
    }

    @Override
    public void count(Example example, double weight) {
        if (!this.isIgnoringMissings) {
            this.count += weight;
        } else {
            double value = example.getValue(this.sourceAttribute);
            if (!Double.isNaN(value)) {
                this.count += weight;
            }
        }
    }

    @Override
    public double get() {
        return this.count;
    }

    @Override
    public void disregard(Example example) {
        if (!this.isIgnoringMissings) {
            this.count -= 1.0;
        } else {
            double value = example.getValue(this.sourceAttribute);
            if (!Double.isNaN(value)) {
                this.count -= 1.0;
            }
        }
    }

    @Override
    public void disregard(Example example, double weight) {
        if (!this.isIgnoringMissings) {
            this.count -= weight;
        } else {
            double value = example.getValue(this.sourceAttribute);
            if (!Double.isNaN(value)) {
                this.count -= weight;
            }
        }
    }
}

