/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.owc.tools.Weight;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.container.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CrossTableOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_A_COLUMN = "values_of_a";
    private static final String ATTRIBUTE_B_VALUE_PREFIX = "b_value_";
    private static final String ATTRIBUTE_TOTAL = "total";
    public static final String PARAMETER_GROUP_A = "group_attribute_a";
    public static final String PARAMETER_GROUP_B = "group_attribute_b";
    public static final String PARAMETER_USE_WEIGHTS = "use_weights";
    public static final String PARAMETER_GENERATE_TOTALS = "generate_totals";
    public static final String PARAMETER_RELATIVE_TOTAL_COUNTS = "show_relative_total_counts";
    public static final String PARAMETER_RELATIVE_COUNTS = "show_relative_counts";
    public static final String PARAMETER_INCLUDE_ATTRIBUTE_NAMES = "include_attribute_names";
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final OutputPort crossTableOutput = (OutputPort)this.getOutputPorts().createPort("cross table output");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");

    public CrossTableOperator(OperatorDescription description) {
        super(description);
        ExampleSetMetaData metaData;
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_GROUP_A, 1));
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_GROUP_B, 1));
        if (this.getParameterAsBoolean(PARAMETER_INCLUDE_ATTRIBUTE_NAMES)) {
            String a = "a";
            String b = "b";
            try {
                a = this.getParameterAsString(PARAMETER_GROUP_A);
                b = this.getParameterAsString(PARAMETER_GROUP_B);
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            metaData = this.getParameterAsBoolean(PARAMETER_GENERATE_TOTALS) ? new ExampleSetCreator(new String[]{"values_of_" + a, b + "_value", ATTRIBUTE_TOTAL}, new int[]{7, 2, 2}).getMetaData() : new ExampleSetCreator(new String[]{"values_of_" + a, b + "_values"}, new int[]{7, 2}).getMetaData();
        } else {
            metaData = this.getParameterAsBoolean(PARAMETER_GENERATE_TOTALS) ? new ExampleSetCreator(new String[]{ATTRIBUTE_A_COLUMN, "b_value_value", ATTRIBUTE_TOTAL}, new int[]{7, 2, 2}).getMetaData() : new ExampleSetCreator(new String[]{ATTRIBUTE_A_COLUMN, "b_value_value"}, new int[]{7, 2}).getMetaData();
        }
        metaData.attributesAreSubset();
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.crossTableOutput, metaData));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        int i;
        Iterator groupBValueIterator;
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 1000) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{1000});
        }
        boolean generateTotals = this.getParameterAsBoolean(PARAMETER_GENERATE_TOTALS);
        boolean generateRelativeTotals = this.getParameterAsBoolean(PARAMETER_RELATIVE_TOTAL_COUNTS);
        String groupAAttributeName = this.getParameterAsString(PARAMETER_GROUP_A);
        String groupBAttributeName = this.getParameterAsString(PARAMETER_GROUP_B);
        Attribute groupAAttribute = set.getAttributes().get(groupAAttributeName);
        Attribute groupBAttribute = set.getAttributes().get(groupBAttributeName);
        boolean useWeights = this.getParameterAsBoolean(PARAMETER_USE_WEIGHTS);
        boolean useRelativeWeight = this.getParameterAsBoolean(PARAMETER_RELATIVE_COUNTS);
        Attribute weightAttribute = set.getAttributes().getWeight();
        if (weightAttribute == null) {
            useWeights = false;
        }
        if (groupAAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{groupAAttributeName});
        }
        if (!groupAAttribute.isNominal()) {
            throw new UserError((Operator)this, "statistics.1", new Object[]{groupAAttributeName, this.getName(), PARAMETER_GROUP_A});
        }
        if (groupBAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{groupBAttributeName});
        }
        if (!groupBAttribute.isNominal()) {
            throw new UserError((Operator)this, "statistics.1", new Object[]{groupBAttributeName, this.getName(), PARAMETER_GROUP_B});
        }
        HashMap<Pair, Weight> crossWeights = new HashMap<Pair, Weight>();
        TreeSet<String> groupAValues = new TreeSet<String>();
        TreeSet<String> groupBValues = new TreeSet<String>();
        Pair hashPair = new Pair(null, null);
        double totalWeight = 0.0;
        for (Example example : set) {
            String nominalValueA = example.getNominalValue(groupAAttribute);
            String nominalValueB = example.getNominalValue(groupBAttribute);
            double weight = 1.0;
            if (useWeights) {
                weight = example.getValue(weightAttribute);
            }
            totalWeight += weight;
            groupAValues.add(nominalValueA);
            groupBValues.add(nominalValueB);
            hashPair.setFirst((Object)nominalValueA);
            hashPair.setSecond((Object)nominalValueB);
            Weight crossWeight = (Weight)crossWeights.get(hashPair);
            if (crossWeight == null) {
                crossWeight = new Weight();
                Pair crossPair = new Pair((Object)nominalValueA, (Object)nominalValueB);
                crossWeights.put(crossPair, crossWeight);
            }
            crossWeight.weight += weight;
        }
        String[] attributeNames = new String[1 + groupBValues.size() + (generateTotals ? 1 : 0)];
        int[] attributeTypes = new int[1 + groupBValues.size() + (generateTotals ? 1 : 0)];
        attributeTypes[0] = 7;
        if (this.getParameterAsBoolean(PARAMETER_INCLUDE_ATTRIBUTE_NAMES)) {
            attributeNames[0] = "values_of_" + groupAAttributeName;
            groupBValueIterator = groupBValues.iterator();
            for (i = 1; i < attributeNames.length - (generateTotals ? 1 : 0); ++i) {
                attributeNames[i] = groupBAttributeName + "_" + (String)groupBValueIterator.next();
                attributeTypes[i] = useWeights || useRelativeWeight ? 4 : 3;
            }
        } else {
            attributeNames[0] = ATTRIBUTE_A_COLUMN;
            groupBValueIterator = groupBValues.iterator();
            for (i = 1; i < attributeNames.length - (generateTotals ? 1 : 0); ++i) {
                attributeNames[i] = ATTRIBUTE_B_VALUE_PREFIX + (String)groupBValueIterator.next();
                attributeTypes[i] = useWeights || useRelativeWeight ? 4 : 3;
            }
        }
        if (generateTotals) {
            attributeNames[attributeNames.length - 1] = ATTRIBUTE_TOTAL;
            attributeTypes[attributeNames.length - 1] = useWeights || useRelativeWeight ? 4 : 3;
        }
        ExampleSetCreator result = new ExampleSetCreator(attributeNames, attributeTypes);
        HashMap<String, Weight> columnWeightSums = null;
        if (generateTotals) {
            columnWeightSums = new HashMap<String, Weight>();
            for (String valueB : groupBValues) {
                columnWeightSums.put(valueB, new Weight());
            }
        }
        for (String valueA : groupAValues) {
            hashPair.setFirst((Object)valueA);
            result.setValue(attributeNames[0], valueA);
            int i2 = 1;
            double rowWeightSum = 0.0;
            for (String valueB : groupBValues) {
                hashPair.setSecond((Object)valueB);
                Weight crossWeight = (Weight)crossWeights.get(hashPair);
                if (crossWeight == null) {
                    result.setValue(attributeNames[i2], 0.0);
                } else {
                    if (useRelativeWeight) {
                        result.setValue(attributeNames[i2], crossWeight.weight / totalWeight);
                    } else {
                        result.setValue(attributeNames[i2], crossWeight.weight);
                    }
                    rowWeightSum += crossWeight.weight;
                }
                if (generateTotals && crossWeight != null) {
                    ((Weight)columnWeightSums.get((Object)valueB)).weight += crossWeight.weight;
                }
                ++i2;
            }
            if (generateTotals) {
                if (generateRelativeTotals) {
                    result.setValue(ATTRIBUTE_TOTAL, rowWeightSum / totalWeight);
                } else {
                    result.setValue(ATTRIBUTE_TOTAL, rowWeightSum);
                }
            }
            result.commit();
        }
        if (generateTotals) {
            result.setValue(attributeNames[0], ATTRIBUTE_TOTAL);
            int i3 = 1;
            for (String valueB : groupBValues) {
                Weight columnWeightSum = (Weight)columnWeightSums.get(valueB);
                if (columnWeightSum == null) {
                    result.setValue(attributeNames[i3], 0.0);
                } else if (generateRelativeTotals) {
                    result.setValue(attributeNames[i3], columnWeightSum.weight / totalWeight);
                } else {
                    result.setValue(attributeNames[i3], columnWeightSum.weight);
                }
                ++i3;
            }
            if (generateRelativeTotals) {
                result.setValue(ATTRIBUTE_TOTAL, 1.0);
            } else {
                result.setValue(ATTRIBUTE_TOTAL, totalWeight);
            }
            result.commit();
        }
        this.exampleSetOutput.deliver((IOObject)set);
        this.crossTableOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_GROUP_A, "Select the first grouping attribute for generating the cross table. The values of this attribute will form the rows of the cross table.", this.exampleSetInput, false, new int[]{1});
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_GROUP_B, "Select the second grouping attribute for generating the cross table. The values of this attribute will form the columns of the cross table.", this.exampleSetInput, false, new int[]{1});
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_INCLUDE_ATTRIBUTE_NAMES, "Specifies whether the resulting columns should contain the names of the selected attributes. For easier automation in loops, disable this.", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_RELATIVE_COUNTS, "Specifies whether instead of the total number, the cross table just contains the relative fraction.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_USE_WEIGHTS, "Specifies whether rows should be counted with their weight or just having all an equal weight of 1.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_GENERATE_TOTALS, "Specifies whether totals of rows and columns should be included in the result table.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_RELATIVE_TOTAL_COUNTS, "Specifies whether totals of rows and columns should be shown as relative fraction.", false, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_RELATIVE_COUNTS, false, true));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_GENERATE_TOTALS, false, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

