/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedAbstractDiscretizationOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class QuantileDiscretizationOperator
extends LicensedAbstractDiscretizationOperator {
    private static final String ATTRIBUTE_QUANTILE = "quantile";
    private static final String ATTRIBUTE_QUANTILE_VALUE = "value";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String PARAMETER_QUANTILES = "quantiles";
    public static final String PARAMETER_GROUP_QUANTILES = "group_quantiles";
    public static final String PARAMETER_GROUPS = "groups";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute", "quantile", "value"}, new int[]{7, 3, 4});
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");

    public QuantileDiscretizationOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet, boolean isLicensed) throws OperatorException {
        int noQuantiles = this.getParameterAsInt(PARAMETER_QUANTILES);
        ExampleSetCreator result = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE, ATTRIBUTE_QUANTILE, ATTRIBUTE_QUANTILE_VALUE}, new int[]{7, 3, 4});
        double[] values = new double[exampleSet.size()];
        HashMap<Attribute, double[]> rangesMap = new HashMap<Attribute, double[]>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) {
                throw new UserError((Operator)this, 144, new Object[]{attribute.getName(), this.getName()});
            }
            int i = 0;
            for (Example example : exampleSet) {
                values[i] = example.getValue(attribute);
                ++i;
            }
            Percentile percentile = new Percentile();
            percentile.setData(values);
            double[] quantileValues = new double[noQuantiles];
            rangesMap.put(attribute, quantileValues);
            for (double quantile = 1.0; quantile <= (double)noQuantiles; quantile += 1.0) {
                double quantileValue = percentile.evaluate(quantile / (double)noQuantiles * 100.0);
                if (this.statisticsOutput.isConnected()) {
                    result.setValue(ATTRIBUTE_ATTRIBUTE, attribute.getName());
                    result.setValue(ATTRIBUTE_QUANTILE, quantile);
                    result.setValue(ATTRIBUTE_QUANTILE_VALUE, quantileValue);
                    result.commit();
                }
                quantileValues[(int)quantile - 1] = quantileValue;
            }
        }
        if (this.statisticsOutput.isConnected()) {
            this.statisticsOutput.deliver((IOObject)result.finish());
        }
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        String quantileName = "Quantile ";
        switch (noQuantiles) {
            case 100: {
                quantileName = "Percentile ";
                break;
            }
            case 10: {
                quantileName = "Decile ";
            }
        }
        model.setRanges(rangesMap, quantileName, 1, 3);
        return model;
    }

    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return DiscretizationModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_QUANTILES, "Specifies how many quantiles should be computed. A value of 100 would compute percentiles, a value of 10 decentiles.", 2, Integer.MAX_VALUE, 100, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

