/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class QuantileOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_QUANTILE = "quantile";
    private static final String ATTRIBUTE_QUANTILE_VALUE = "value";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String PARAMETER_QUANTILES = "quantiles";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute", "quantile", "value"}, new int[]{7, 3, 4});
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private final AttributeSubsetSelector attributeSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput, new int[]{2});

    public QuantileOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetInput));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 1000) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{1000});
        }
        int noQuantiles = this.getParameterAsInt(PARAMETER_QUANTILES);
        ExampleSetCreator result = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE, ATTRIBUTE_QUANTILE, ATTRIBUTE_QUANTILE_VALUE}, new int[]{7, 3, 4});
        Set includedAttributes = this.attributeSubsetSelector.getAttributeSubset(set, false);
        double[] values = new double[set.size()];
        for (Attribute attribute : includedAttributes) {
            if (!attribute.isNumerical()) {
                throw new UserError((Operator)this, 144, new Object[]{attribute.getName(), this.getName()});
            }
            int i = 0;
            for (Example example : set) {
                values[i] = example.getValue(attribute);
                ++i;
            }
            Percentile percentile = new Percentile();
            percentile.setData(values);
            if (!this.statisticsOutput.isConnected()) continue;
            for (double quantile = 1.0; quantile <= (double)noQuantiles; quantile += 1.0) {
                result.setValue(ATTRIBUTE_ATTRIBUTE, attribute.getName());
                result.setValue(ATTRIBUTE_QUANTILE, quantile);
                result.setValue(ATTRIBUTE_QUANTILE_VALUE, percentile.evaluate(quantile / (double)noQuantiles * 100.0));
                result.commit();
            }
        }
        this.exampleSetOutput.deliver((IOObject)set);
        this.statisticsOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSubsetSelector.getParameterTypes());
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_QUANTILES, "Specifies how many quantiles should be computed. A value of 100 would compute percentiles, a value of 10 decentiles.", 2, Integer.MAX_VALUE, 100, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

