/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.curve;

import com.owc.license.ProductInformation;
import com.owc.objects.statistics.SurvivalCurveChartObject;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Iterator;
import java.util.List;

public class NelsonAalenEstimationOperator
extends LicensedOperator {
    public static final String ATTRIBUTE_TIME = "Time";
    private static final String ATTRIBUTE_UNDER_RISK = "UnderRisk";
    public static final String ATTRIBUTE_IS_CENSORED = "IsCensored";
    public static final String ATTRIBUTE_NELSON_AALEN = "NelsonAalen";
    private static final String ATTRIBUTE_VARIANCE = "Variance";
    private static final String ATTRIBUTE_STANDARD_ERROR = "StandardError";
    public static final String ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL = "UpperConfidenceInterval";
    public static final String ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL = "LowerConfidenceInterval";
    public static final String ATTRIBUTE_EVENT = "Event";
    public static final String ATTRIBUTE_CENSORED = "Censored";
    private static String[] TABLE_HEADER_NAMES = new String[]{"Time", "UnderRisk", "Event", "Censored", "IsCensored", "Variance", "StandardError", "NelsonAalen"};
    private static int[] TABLE_HEADER_TYPES = new int[]{2, 3, 3, 3, 6, 2, 2, 4};
    public static final String PARAMETER_TIME_ATTRIBUTE = "time_attribute";
    public static final String PARAMETER_EVENT_ATTRIBUTE = "event_attribute";
    public static final String PARAMETER_EVENT_VALUE = "event_value";
    public static final String PARAMETER_CENSOR_VALUE = "censoring_value";
    public static final String PARAMETER_SPECIFY_GROUP_SIZE = "specify_group_size";
    public static final String PARAMETER_GROUP_SIZE = "group_size";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set input", ExampleSet.class);
    private final OutputPort curveOutput = (OutputPort)this.getOutputPorts().createPort("chart output");
    private final OutputPort curveTableOutput = (OutputPort)this.getOutputPorts().createPort("curve table output");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private ExampleSetCreator exampleSetCreator = new ExampleSetCreator(TABLE_HEADER_NAMES, TABLE_HEADER_TYPES);

    public NelsonAalenEstimationOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_EVENT_ATTRIBUTE));
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_TIME_ATTRIBUTE));
        this.getTransformer().addGenerationRule(this.curveOutput, SurvivalCurveChartObject.class);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.curveTableOutput, this.exampleSetCreator.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        int currentAtRisk;
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 100) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{100});
        }
        String timeAttributeName = this.getParameterAsString(PARAMETER_TIME_ATTRIBUTE);
        String eventAttributeName = this.getParameterAsString(PARAMETER_EVENT_ATTRIBUTE);
        Attribute timeAttribute = set.getAttributes().get(timeAttributeName);
        if (timeAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{timeAttributeName});
        }
        SortedExampleSet sortedSet = new SortedExampleSet(set, timeAttribute, 0);
        timeAttribute = sortedSet.getAttributes().get(timeAttributeName);
        Attribute eventAttribute = sortedSet.getAttributes().get(eventAttributeName);
        if (timeAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{timeAttributeName});
        }
        if (!timeAttribute.isNumerical() || timeAttribute.isDateTime()) {
            throw new UserError((Operator)this, 144, new Object[]{timeAttributeName, this.getName()});
        }
        if (eventAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{eventAttributeName});
        }
        double eventValue = 0.0;
        double censorValue = 0.0;
        if (eventAttribute.isNumerical()) {
            eventValue = this.getParameterAsDouble(PARAMETER_EVENT_VALUE);
            censorValue = this.getParameterAsDouble(PARAMETER_CENSOR_VALUE);
        } else {
            eventValue = eventAttribute.getMapping().getIndex(this.getParameterAsString(PARAMETER_EVENT_VALUE));
            if (eventValue == -1.0) {
                throw new UserError((Operator)this, "statistics.8", new Object[]{eventAttributeName, this.getName(), PARAMETER_EVENT_VALUE});
            }
            censorValue = eventAttribute.getMapping().getIndex(this.getParameterAsString(PARAMETER_CENSOR_VALUE));
            if (censorValue == -1.0) {
                throw new UserError((Operator)this, "statistics.8", new Object[]{eventAttributeName, this.getName(), PARAMETER_CENSOR_VALUE});
            }
        }
        ExampleSetCreator creator = this.exampleSetCreator.getInstance();
        int initialGroupSize = sortedSet.size();
        if (this.getParameterAsBoolean(PARAMETER_SPECIFY_GROUP_SIZE)) {
            initialGroupSize = this.getParameterAsInt(PARAMETER_GROUP_SIZE);
        }
        Iterator iterator = sortedSet.iterator();
        double lastTime = Double.NaN;
        int lastAtRisk = currentAtRisk = initialGroupSize;
        int currentCensored = 0;
        int currentEvent = 0;
        double currentNelsonAalen = 0.0;
        double lastNelsonAalen = 0.0;
        double currentVarianceSum = 0.0;
        double se = 0.0;
        while (iterator.hasNext()) {
            boolean isCensored;
            Example example = (Example)iterator.next();
            double currentTime = example.getValue(timeAttribute);
            if (Double.isNaN(lastTime)) {
                lastTime = currentTime;
            }
            if (currentTime != lastTime) {
                creator.commit();
                lastAtRisk = currentAtRisk;
                currentCensored = 0;
                currentEvent = 0;
                lastNelsonAalen = currentNelsonAalen;
            }
            lastTime = currentTime;
            double currentEventValue = example.getValue(eventAttribute);
            boolean bl = isCensored = currentEventValue == censorValue;
            if (isCensored) {
                ++currentCensored;
            }
            if (currentEventValue == eventValue) {
                ++currentEvent;
            }
            currentNelsonAalen = lastNelsonAalen + (double)currentEvent / (double)lastAtRisk;
            if (--currentAtRisk != 0 && currentAtRisk != 1) {
                se += Math.sqrt(currentVarianceSum += (double)((currentAtRisk - currentEvent) * currentEvent) / ((double)(currentAtRisk - 1) * (double)currentAtRisk * (double)currentAtRisk));
            }
            creator.setValue(ATTRIBUTE_TIME, currentTime);
            creator.setValue(ATTRIBUTE_UNDER_RISK, currentAtRisk + currentCensored + currentEvent);
            creator.setValue(ATTRIBUTE_CENSORED, currentCensored);
            creator.setValue(ATTRIBUTE_EVENT, currentEvent);
            creator.setValue(ATTRIBUTE_NELSON_AALEN, currentNelsonAalen);
            creator.setValue(ATTRIBUTE_IS_CENSORED, currentCensored > 0);
            creator.setValue(ATTRIBUTE_VARIANCE, currentVarianceSum);
            creator.setValue(ATTRIBUTE_STANDARD_ERROR, se);
        }
        creator.commit();
        ExampleSet curveTable = creator.finish();
        String title = "Nelson Aalen cumulative hazard";
        String domain = "time";
        String range = "percentage";
        this.curveOutput.deliver((IOObject)new SurvivalCurveChartObject(curveTable, title, ATTRIBUTE_NELSON_AALEN, ATTRIBUTE_TIME, ATTRIBUTE_IS_CENSORED, ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL, ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL, false, domain, range));
        this.exampleSetOutput.deliver((IOObject)set);
        this.curveTableOutput.deliver((IOObject)curveTable);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_TIME_ATTRIBUTE, "Select the time attribute of your study. This should uniformly deliver the point in time after start of the study for each object. Be careful with absolute values, if different objects started at different times.", this.exampleSetInput, false, new int[]{2});
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_EVENT_ATTRIBUTE, "Select the attribute that contains a flag whether an object of the study caused an event or whether it was censored. Notice that you need to specify the values below. All not specified values will be ignored.", this.exampleSetInput, false, new int[]{0});
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_EVENT_VALUE, "This is the value that indicates that an object received an event.", false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_CENSOR_VALUE, "This is the value that indicates that an object has left the study.", false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_SPECIFY_GROUP_SIZE, "Allows you to specify the size of the sample group if not all members of the group are censored or have received an event.", false));
        type = new ParameterTypeInt(PARAMETER_GROUP_SIZE, "Size of the sample group", 1, Integer.MAX_VALUE, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_SPECIFY_GROUP_SIZE, true, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

