/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.matrix;

import com.owc.operator.statistics.descriptive.matrix.AbstractMatrixBasedOperator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;

public class CovarianceMatrixOperator
extends AbstractMatrixBasedOperator {
    public static final String PARAMETER_CORRECT_BIAS = "correct_bias";

    public CovarianceMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected NumericalMatrix computeMatrix(RealMatrix matrix, ExampleSet exampleSet) {
        Covariance covariance = new Covariance(matrix, this.getParameterAsBoolean(PARAMETER_CORRECT_BIAS));
        RealMatrix covarianceMatrix = covariance.getCovarianceMatrix();
        return CovarianceMatrixOperator.createNumericalMatrix("Covariance Matrix", exampleSet, covarianceMatrix.getData());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_CORRECT_BIAS, "Selects whether the covariance calculation should be bias corrected.", true, false));
        return types;
    }
}

