/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.matrix;

import com.owc.operator.statistics.descriptive.matrix.AbstractMatrixBasedOperator;
import com.owc.operator.statistics.tools.NumericalMatrixGenerationRule;
import com.owc.tools.EnumTools;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.TiesStrategy;

public class SpearmansCorrelationMatrixOperator
extends AbstractMatrixBasedOperator {
    public static final String PARAMETER_UNKNOWN_HANDLING_STRATEGY = "unknown_handling";
    public static final String PARAMETER_TIE_HANDLING_STRATEGY = "tie_handling";
    public static String[] TIE_HANDLING_STRATEGY = EnumTools.transformEnumNamesToParameterList(TiesStrategy.values());
    public static String[] UNKNOWN_HANDLING_STRATEGY = EnumTools.transformEnumNamesToParameterList(NaNStrategy.values());
    private final OutputPort pMatrixOutput = (OutputPort)this.getOutputPorts().createPort("p-value matrix");
    private final OutputPort errorMatrixOutput = (OutputPort)this.getOutputPorts().createPort("error matrix");

    public SpearmansCorrelationMatrixOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new NumericalMatrixGenerationRule(this.getExampleSetInput(), this.pMatrixOutput));
        this.getTransformer().addRule((MDTransformationRule)new NumericalMatrixGenerationRule(this.getExampleSetInput(), this.errorMatrixOutput));
    }

    @Override
    protected NumericalMatrix computeMatrix(RealMatrix matrix, ExampleSet exampleSet) throws UserError, UndefinedParameterError {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.valueOf(this.getParameterAsString(PARAMETER_UNKNOWN_HANDLING_STRATEGY).toUpperCase()), TiesStrategy.valueOf(this.getParameterAsString(PARAMETER_TIE_HANDLING_STRATEGY).toUpperCase()));
        try {
            SpearmansCorrelation correlation = new SpearmansCorrelation(matrix, ranking);
            if (this.pMatrixOutput.isConnected()) {
                this.pMatrixOutput.deliver((IOObject)SpearmansCorrelationMatrixOperator.createNumericalMatrix("p-values", exampleSet, correlation.getRankCorrelation().getCorrelationPValues().getData()));
            }
            if (this.errorMatrixOutput.isConnected()) {
                this.errorMatrixOutput.deliver((IOObject)SpearmansCorrelationMatrixOperator.createNumericalMatrix("standard errors", exampleSet, correlation.getRankCorrelation().getCorrelationStandardErrors().getData()));
            }
            RealMatrix correlationMatrix = correlation.getCorrelationMatrix();
            return SpearmansCorrelationMatrixOperator.createNumericalMatrix("Spearmans Correlation Matrix", exampleSet, correlationMatrix.getData());
        }
        catch (NotANumberException ex) {
            throw new UserError((Operator)this, "statistics.3", new Object[]{this.getName()});
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_TIE_HANDLING_STRATEGY, "Select a strategy to handle ties in the ranking.", TIE_HANDLING_STRATEGY, 3, false);
        types.add((ParameterType)type);
        type = new ParameterTypeCategory(PARAMETER_UNKNOWN_HANDLING_STRATEGY, "Select a strategy to handle unknown values during ranking.", UNKNOWN_HANDLING_STRATEGY, 0, false);
        types.add((ParameterType)type);
        return types;
    }
}

