/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tests.mean;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;

public class KolmogorovSmirnovTestOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_P_VALUE = "p_value";
    private static final String ATTRIBUTE_STATISTIC = "test_statistic";
    private static final String ATTRIBUTE_A_ATTRIBUTE = "a_attribute";
    private static final String ATTRIBUTE_B_ATTRIBUTE = "b_attribute";
    private static final String ATTRIBUTE_NULL_HYPOTHESES_REJECTED = "null_hypothesis_rejected";
    public static final String PARAMETER_SPECIFY_SAMPLES = "specify_samples";
    public static final String PARAMETER_SAMPLE_ATTRIBUTES = "sample_attributes";
    public static final String PARAMETER_SAMPLE_ATTRIBUTE_A = "attribute_X";
    public static final String PARAMETER_SAMPLE_ATTRIBUTE_B = "attribute_Y";
    public static final String PARAMETER_ALPHA = "confidence_level";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"a_attribute", "b_attribute", "test_statistic", "p_value", "null_hypothesis_rejected"}, new int[]{7, 7, 4, 4, 6});
    private final InputPort exampleSetAInput = (InputPort)this.getInputPorts().createPort("example set a input");
    private final InputPort exampleSetBInput = (InputPort)this.getInputPorts().createPort("example set b input");
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private final OutputPort exampleSetAOutput = (OutputPort)this.getOutputPorts().createPort("example set a output");
    private final OutputPort exampleSetBOutput = (OutputPort)this.getOutputPorts().createPort("example set b output");

    public KolmogorovSmirnovTestOperator(OperatorDescription description) {
        super(description);
        this.exampleSetAInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetAInput));
        this.exampleSetBInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetBInput));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetAInput, this.exampleSetAOutput);
        this.getTransformer().addPassThroughRule(this.exampleSetBInput, this.exampleSetBOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet setA = (ExampleSet)this.exampleSetAInput.getData(ExampleSet.class);
        ExampleSet setB = (ExampleSet)this.exampleSetBInput.getData(ExampleSet.class);
        if (!(isLicensed || setA.size() <= 150 && setB.size() <= 150)) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{150});
        }
        double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        LinkedHashMap<Attribute, Attribute> sampleGroups = new LinkedHashMap<Attribute, Attribute>();
        if (this.getParameterAsBoolean(PARAMETER_SPECIFY_SAMPLES)) {
            List sampleAttributes = this.getParameterList(PARAMETER_SAMPLE_ATTRIBUTES);
            Iterator iterator = sampleAttributes.iterator();
            while (iterator.hasNext()) {
                String[] matching = (String[])iterator.next();
                Attribute attributeA = setA.getAttributes().get(matching[0]);
                Attribute attributeB = setB.getAttributes().get(matching[1]);
                if (attributeA == null) {
                    throw new UserError((Operator)this, 160, new Object[]{matching[0]});
                }
                if (attributeB == null) {
                    throw new UserError((Operator)this, 160, new Object[]{matching[1]});
                }
                if (!attributeA.isNumerical()) {
                    throw new UserError((Operator)this, 144, new Object[]{attributeA.getName(), this.getName()});
                }
                if (!attributeB.isNumerical()) {
                    throw new UserError((Operator)this, 144, new Object[]{attributeB.getName(), this.getName()});
                }
                sampleGroups.put(attributeA, attributeB);
            }
        } else {
            for (Attribute attributeA : setA.getAttributes()) {
                Attribute attributeB = setB.getAttributes().get(attributeA.getName());
                if (attributeB == null || !attributeA.isNumerical() || !attributeB.isNumerical()) continue;
                sampleGroups.put(attributeA, attributeB);
            }
        }
        ExampleSetCreator result = new ExampleSetCreator(new String[]{ATTRIBUTE_A_ATTRIBUTE, ATTRIBUTE_B_ATTRIBUTE, ATTRIBUTE_STATISTIC, ATTRIBUTE_P_VALUE, ATTRIBUTE_NULL_HYPOTHESES_REJECTED}, new int[]{7, 7, 4, 4, 6});
        double[] valuesA = new double[setA.size()];
        double[] valuesB = new double[setB.size()];
        for (Map.Entry sampleGroup : sampleGroups.entrySet()) {
            int i = 0;
            for (Example example : setA) {
                valuesA[i] = example.getValue((Attribute)sampleGroup.getKey());
                ++i;
            }
            i = 0;
            for (Example example : setB) {
                valuesB[i] = example.getValue((Attribute)sampleGroup.getValue());
                ++i;
            }
            KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
            double statistic = test.kolmogorovSmirnovStatistic(valuesA, valuesB);
            double pValue = test.kolmogorovSmirnovTest(valuesA, valuesB);
            boolean nullHypothesisRejected = pValue < alpha;
            result.setValue(ATTRIBUTE_A_ATTRIBUTE, ((Attribute)sampleGroup.getKey()).getName());
            result.setValue(ATTRIBUTE_B_ATTRIBUTE, ((Attribute)sampleGroup.getValue()).getName());
            result.setValue(ATTRIBUTE_P_VALUE, pValue);
            result.setValue(ATTRIBUTE_STATISTIC, statistic);
            result.setValue(ATTRIBUTE_NULL_HYPOTHESES_REJECTED, nullHypothesisRejected);
            result.commit();
        }
        this.exampleSetAOutput.deliver((IOObject)setA);
        this.exampleSetBOutput.deliver((IOObject)setB);
        this.statisticsOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_SPECIFY_SAMPLES, "If checked, you can specify which attributes of set A are compared with which attributes of set B. Otherwise all attributes with same name are compared.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeList(PARAMETER_SAMPLE_ATTRIBUTES, "With this list you can specify which attributes of set A should be tested against which attributes of set B.", (ParameterType)new ParameterTypeAttribute(PARAMETER_SAMPLE_ATTRIBUTE_A, "The values of this attribute will create the set A for the test. It will be tested against the values of the B attribute.", this.exampleSetAInput, new int[]{2}), (ParameterType)new ParameterTypeAttribute(PARAMETER_SAMPLE_ATTRIBUTE_B, "The values of this attribute will create the set B for the test. It will be tested against the values of the A attribute.", this.exampleSetBInput, new int[]{2}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_SPECIFY_SAMPLES, false, true));
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ALPHA, "Performs a test evaluating the null hypothesis that the mean of the population from which example set is drawn equals the specified means. Returns true iff the null hypothesis can be rejected with confidence 1 - alpha.", 0.0, 1.0, 0.05, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

