/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tests.mean;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.inference.OneWayAnova;

public class OneWayAnovaTestOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_P_VALUE = "p_value";
    private static final String ATTRIBUTE_F_VALUE = "f_value";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_NULL_HYPOTHESES_REJECTED = "null_hypothesis_rejected";
    public static final String PARAMETER_ALPHA = "confidence_level";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute", "f_value", "p_value", "null_hypothesis_rejected"}, new int[]{7, 4, 4, 6});
    private final InputPortExtender exampleSetInputExtender = new InputPortExtender("group sets", (Ports)this.getInputPorts(), (MetaData)new ExampleSetMetaData(), 2);
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private final OutputPort exampleSetsOutput = (OutputPort)this.getOutputPorts().createPort("example sets output");

    public OneWayAnovaTestOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInputExtender.start();
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exampleSetsOutput, (MetaData)new CollectionMetaData((MetaData)new ExampleSetMetaData())));
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        List groupSets = this.exampleSetInputExtender.getData(ExampleSet.class, true);
        if (!isLicensed) {
            for (ExampleSet set : groupSets) {
                if (set.size() <= 150) continue;
                throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{150});
            }
        }
        double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        ArrayList<Attribute> samples = new ArrayList<Attribute>();
        ExampleSet lastSet = (ExampleSet)groupSets.remove(groupSets.size() - 1);
        for (Attribute attribute : lastSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            boolean isAvailableInAll = true;
            for (Object groupSet : groupSets) {
                Attribute attributeB = groupSet.getAttributes().get(attribute.getName());
                isAvailableInAll = isAvailableInAll && attributeB != null && attributeB.isNumerical();
            }
            if (!isAvailableInAll) continue;
            samples.add(attribute);
        }
        groupSets.add(lastSet);
        ExampleSetCreator result = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE, ATTRIBUTE_F_VALUE, ATTRIBUTE_P_VALUE, ATTRIBUTE_NULL_HYPOTHESES_REJECTED}, new int[]{7, 4, 4, 6});
        for (Attribute sample : samples) {
            LinkedList<double[]> groupValuesList = new LinkedList<double[]>();
            for (ExampleSet groupSet : groupSets) {
                double[] groupValues = new double[groupSet.size()];
                int i = 0;
                for (Example example : groupSet) {
                    groupValues[i] = example.getValue(sample);
                    ++i;
                }
                groupValuesList.add(groupValues);
            }
            OneWayAnova test = new OneWayAnova();
            double fValue = test.anovaFValue(groupValuesList);
            double pValue = test.anovaPValue(groupValuesList);
            boolean nullHypothesisRejected = pValue < alpha;
            result.setValue(ATTRIBUTE_ATTRIBUTE, sample.getName());
            result.setValue(ATTRIBUTE_P_VALUE, pValue);
            result.setValue(ATTRIBUTE_F_VALUE, fValue);
            result.setValue(ATTRIBUTE_NULL_HYPOTHESES_REJECTED, nullHypothesisRejected);
            result.commit();
        }
        this.exampleSetsOutput.deliver((IOObject)new IOObjectCollection(groupSets));
        this.statisticsOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ALPHA, "Performs a test evaluating the null hypothesis that the mean of the population from which example set is drawn equals the specified means. Returns true iff the null hypothesis can be rejected with confidence 1 - alpha.", 0.0, 0.5, 0.05, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

