/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tools;

import com.owc.operator.statistics.tools.NumericalMatrixToFullExampleSetMDRule;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class MatrixToExampleSetOperator
extends Operator {
    public static final String PARAMETER_OMIT_DIAGONAL = "omit_diagonal_entries";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_ATTRIBUTE_A = "attribute_a";
    private static final String ATTRIBUTE_ATTRIBUTE_B = "attribute_b";
    public static final String ATTRIBUTE_ATTRIBUTE_COLUMN = "attribute";
    private static final ExampleSetCreator PAIRWISE_RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute_a", "attribute_b", "value"}, new int[]{7, 7, 4});
    private final InputPort matrixInput = this.getInputPorts().createPort("matrix input", NumericalMatrix.class);
    private final OutputPort matrixOutput = (OutputPort)this.getOutputPorts().createPort("matrix output");
    private final OutputPort fullSetOutput = (OutputPort)this.getOutputPorts().createPort("block representation example set output");
    private final OutputPort pairwiseSetOutput = (OutputPort)this.getOutputPorts().createPort("pairwise representation example set output");

    public MatrixToExampleSetOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.pairwiseSetOutput, PAIRWISE_RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addRule((MDTransformationRule)new NumericalMatrixToFullExampleSetMDRule(this.matrixInput, this.fullSetOutput));
        this.getTransformer().addPassThroughRule(this.matrixInput, this.matrixOutput);
    }

    public void doWork() throws OperatorException {
        NumericalMatrix matrix = (NumericalMatrix)this.matrixInput.getData(NumericalMatrix.class);
        boolean omitDiagnalEntries = this.getParameterAsBoolean(PARAMETER_OMIT_DIAGONAL);
        this.matrixOutput.deliver((IOObject)matrix);
        if (this.pairwiseSetOutput.isConnected()) {
            ExampleSetCreator pairwiseCreator = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE_A, ATTRIBUTE_ATTRIBUTE_B, ATTRIBUTE_VALUE}, new int[]{7, 7, 4});
            for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
                for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
                    if (omitDiagnalEntries && row == column) continue;
                    pairwiseCreator.setValue(ATTRIBUTE_ATTRIBUTE_A, matrix.getRowName(row));
                    pairwiseCreator.setValue(ATTRIBUTE_ATTRIBUTE_B, matrix.getColumnName(column));
                    pairwiseCreator.setValue(ATTRIBUTE_VALUE, matrix.getValue(row, column));
                    pairwiseCreator.commit();
                }
            }
            this.pairwiseSetOutput.deliver((IOObject)pairwiseCreator.finish());
        }
        if (this.fullSetOutput.isConnected()) {
            String[] attributeNames = new String[matrix.getNumberOfColumns() + 1];
            int[] valueTypes = new int[matrix.getNumberOfColumns() + 1];
            attributeNames[0] = ATTRIBUTE_ATTRIBUTE_COLUMN;
            valueTypes[0] = 7;
            for (int i = 0; i < matrix.getNumberOfColumns(); ++i) {
                attributeNames[i + 1] = matrix.getColumnName(i);
                valueTypes[i + 1] = 4;
            }
            ExampleSetCreator fullCreator = new ExampleSetCreator(attributeNames, valueTypes);
            for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
                fullCreator.setValue(ATTRIBUTE_ATTRIBUTE_COLUMN, matrix.getRowName(row));
                for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
                    fullCreator.setValue(matrix.getColumnName(column), matrix.getValue(row, column));
                }
                fullCreator.commit();
            }
            this.fullSetOutput.deliver((IOObject)fullCreator.finish());
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_OMIT_DIAGONAL, "If checked, the diagnoal entries will not be added to the pairwise representation. This can be helpful to further process correlation matrices, where the diagonal entries are always 1.", false, false));
        return types;
    }
}

