/*
 * Decompiled with CFR 0.152.
 */
package com.owc.process.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OneToManyExtender
implements PortExtender {
    private final String name;
    private final Ports<InputPort> oneInputPorts;
    private final ArrayList<Ports<OutputPort>> manyOutputPorts;
    private int minNumber = 0;
    private final List<PortRow> managedRows = new LinkedList<PortRow>();
    private boolean isChanging = false;
    private int runningId = 0;
    private final Observer<Port> observer = new Observer<Port>(){

        public void update(Observable<Port> observable, Port arg) {
            OneToManyExtender.this.updatePorts();
        }
    };

    public OneToManyExtender(String name, InputPorts inputPorts, OutputPorts[] multiOutputPorts) {
        this.name = name;
        this.oneInputPorts = inputPorts;
        this.manyOutputPorts = new ArrayList<OutputPorts>(Arrays.asList(multiOutputPorts));
        inputPorts.registerPortExtender((PortExtender)this);
        for (OutputPorts ports : multiOutputPorts) {
            ports.registerPortExtender((PortExtender)this);
        }
    }

    public <T extends IOObject> List<T> getData(Class<T> desiredClass) throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (PortRow multiPortTupel : this.managedRows) {
            results.add(multiPortTupel.oneInputPort.getDataOrNull(desiredClass));
        }
        return results;
    }

    public void addOutputPorts(Ports<OutputPort> multiPorts, int index) {
        this.manyOutputPorts.add(index, multiPorts);
        int id = 1;
        for (PortRow row : this.managedRows) {
            row.manyOutputPorts.add(index, (OutputPort)multiPorts.createPassThroughPort(this.name + " " + id));
            ++id;
        }
        multiPorts.addObserver(this.observer, false);
        this.updatePorts();
    }

    public void removeOutputPorts(int index) {
        Ports<OutputPort> oldPorts = this.manyOutputPorts.remove(index);
        oldPorts.removeObserver(this.observer);
        for (PortRow pair : this.managedRows) {
            pair.manyOutputPorts.remove(index);
        }
        this.updatePorts();
    }

    public void start() {
        this.managedRows.add(this.createPortRow());
        this.fixNames();
        this.oneInputPorts.addObserver(this.observer, false);
        for (Ports<OutputPort> ports : this.manyOutputPorts) {
            ports.addObserver(this.observer, false);
        }
    }

    public void deliver(List<IOObject> objects) {
        int i = 0;
        for (IOObject object : objects) {
            if (object != null && this.managedRows.size() > i) {
                for (OutputPort port : this.managedRows.get((int)i).manyOutputPorts) {
                    port.deliver(object);
                }
            }
            ++i;
        }
    }

    public String getNamePrefix() {
        return this.name + " ";
    }

    public void ensureMinimumNumberOfPorts(int minNumber) {
        this.minNumber = minNumber;
        this.updatePorts();
    }

    private void updatePorts() {
        if (!this.isChanging) {
            this.isChanging = true;
            boolean first = true;
            PortRow foundDisconnected = null;
            Iterator<PortRow> i = this.managedRows.iterator();
            while (i.hasNext()) {
                PortRow pair = i.next();
                if (!pair.isDisconnected()) continue;
                if (first) {
                    first = false;
                    foundDisconnected = pair;
                    continue;
                }
                if (this.minNumber != 0) continue;
                this.deletePortRow(pair);
                i.remove();
            }
            if (foundDisconnected == null || this.managedRows.size() < this.minNumber) {
                do {
                    this.managedRows.add(this.createPortRow());
                } while (this.managedRows.size() < this.minNumber);
            } else if (this.minNumber == 0) {
                this.managedRows.remove(foundDisconnected);
                this.managedRows.add(foundDisconnected);
                this.oneInputPorts.pushDown((Port)foundDisconnected.oneInputPort);
                for (int j = 0; j < this.manyOutputPorts.size(); ++j) {
                    this.manyOutputPorts.get(j).pushDown((Port)foundDisconnected.manyOutputPorts.get(j));
                }
            }
            this.fixNames();
            this.isChanging = false;
        }
    }

    private PortRow createPortRow() {
        ++this.runningId;
        InputPort newOneInputPort = (InputPort)this.oneInputPorts.createPassThroughPort(this.name + " " + this.runningId);
        ArrayList<OutputPort> newManyOutputPorts = new ArrayList<OutputPort>(this.manyOutputPorts.size());
        for (Ports<OutputPort> ports : this.manyOutputPorts) {
            OutputPort newManyOutputPort = (OutputPort)ports.createPassThroughPort(this.name + " " + this.runningId);
            newManyOutputPorts.add(newManyOutputPort);
        }
        return new PortRow(newOneInputPort, newManyOutputPorts);
    }

    private void deletePortRow(PortRow row) {
        this.oneInputPorts.removePort((Port)row.oneInputPort);
        for (OutputPort outputPort : row.manyOutputPorts) {
            if (outputPort.isConnected()) {
                outputPort.disconnect();
            }
            outputPort.getPorts().removePort((Port)outputPort);
        }
    }

    private void fixNames() {
        this.runningId = 0;
        for (PortRow pair : this.managedRows) {
            ++this.runningId;
            this.oneInputPorts.renamePort((Port)pair.oneInputPort, this.name + "_tmp_" + this.runningId);
            for (OutputPort port : pair.manyOutputPorts) {
                port.getPorts().renamePort((Port)port, this.name + "_tmp_" + this.runningId);
            }
        }
        this.runningId = 0;
        for (PortRow pair : this.managedRows) {
            ++this.runningId;
            this.oneInputPorts.renamePort((Port)pair.oneInputPort, this.name + " " + this.runningId);
            for (OutputPort port : pair.manyOutputPorts) {
                port.getPorts().renamePort((Port)port, this.name + " " + this.runningId);
            }
        }
    }

    public boolean isConnected(OutputPorts ports) {
        for (PortRow pair : this.managedRows) {
            for (OutputPort port : pair.manyOutputPorts) {
                if (port.getPorts() != ports || !port.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnected() {
        for (PortRow pair : this.managedRows) {
            for (OutputPort port : pair.manyOutputPorts) {
                if (!port.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public MDTransformationRule makePassThroughRule() {
        return new MDTransformationRule(){

            public void transformMD() {
                for (PortRow row : OneToManyExtender.this.managedRows) {
                    MetaData metaData = row.oneInputPort.getMetaData();
                    for (OutputPort outputPort : row.manyOutputPorts) {
                        MetaData clonedMetaData = null;
                        if (metaData != null) {
                            clonedMetaData = metaData.clone();
                            clonedMetaData.addToHistory(outputPort);
                        }
                        outputPort.deliverMD(clonedMetaData);
                    }
                }
            }
        };
    }

    public List<PortRow> getPortRows() {
        return this.managedRows;
    }

    public class PortRow {
        protected InputPort oneInputPort;
        protected ArrayList<OutputPort> manyOutputPorts;

        public PortRow(InputPort singlePort, ArrayList<OutputPort> multiPorts) {
            this.oneInputPort = singlePort;
            this.manyOutputPorts = multiPorts;
        }

        public boolean isDisconnected() {
            if (this.oneInputPort.isConnected() || this.oneInputPort.isLocked()) {
                return false;
            }
            for (Port port : this.manyOutputPorts) {
                if (!port.isConnected() && !port.isLocked()) continue;
                return false;
            }
            return true;
        }

        public InputPort getInputPort() {
            return this.oneInputPort;
        }

        public List<OutputPort> getOutputPorts() {
            return this.manyOutputPorts;
        }
    }
}

